@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin.inputs

import com.pulumi.aws.workspaces.inputs.GetDirectoryPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDirectory.
 * @property directoryId Directory identifier for registration in WorkSpaces service.
 * @property tags A map of tags assigned to the WorkSpaces directory.
 */
public data class GetDirectoryPlainArgs(
    public val directoryId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.workspaces.inputs.GetDirectoryPlainArgs> {
    override fun toJava(): com.pulumi.aws.workspaces.inputs.GetDirectoryPlainArgs =
        com.pulumi.aws.workspaces.inputs.GetDirectoryPlainArgs.builder()
            .directoryId(directoryId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetDirectoryPlainArgs].
 */
@PulumiTagMarker
public class GetDirectoryPlainArgsBuilder internal constructor() {
    private var directoryId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Directory identifier for registration in WorkSpaces service.
     */
    @JvmName("qdxoefclvqkubvtc")
    public suspend fun directoryId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.directoryId = mapped
    }

    /**
     * @param value A map of tags assigned to the WorkSpaces directory.
     */
    @JvmName("gqfoiuwfrjupeych")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A map of tags assigned to the WorkSpaces directory.
     */
    @JvmName("vmeoxsibttrarjvo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetDirectoryPlainArgs = GetDirectoryPlainArgs(
        directoryId = directoryId ?: throw PulumiNullFieldException("directoryId"),
        tags = tags,
    )
}
