@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin.inputs

import com.pulumi.aws.workspaces.inputs.GetImagePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getImage.
 * @property imageId ID of the image.
 */
public data class GetImagePlainArgs(
    public val imageId: String,
) : ConvertibleToJava<com.pulumi.aws.workspaces.inputs.GetImagePlainArgs> {
    override fun toJava(): com.pulumi.aws.workspaces.inputs.GetImagePlainArgs =
        com.pulumi.aws.workspaces.inputs.GetImagePlainArgs.builder()
            .imageId(imageId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetImagePlainArgs].
 */
@PulumiTagMarker
public class GetImagePlainArgsBuilder internal constructor() {
    private var imageId: String? = null

    /**
     * @param value ID of the image.
     */
    @JvmName("idgwlokvwqcvenmm")
    public suspend fun imageId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.imageId = mapped
    }

    internal fun build(): GetImagePlainArgs = GetImagePlainArgs(
        imageId = imageId ?: throw PulumiNullFieldException("imageId"),
    )
}
