@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin.inputs

import com.pulumi.aws.workspaces.inputs.IpGroupRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description The description of the IP group.
 * @property source The IP address range, in CIDR notation, e.g., `10.0.0.0/16`
 */
public data class IpGroupRuleArgs(
    public val description: Output<String>? = null,
    public val source: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.workspaces.inputs.IpGroupRuleArgs> {
    override fun toJava(): com.pulumi.aws.workspaces.inputs.IpGroupRuleArgs =
        com.pulumi.aws.workspaces.inputs.IpGroupRuleArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .source(source.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IpGroupRuleArgs].
 */
@PulumiTagMarker
public class IpGroupRuleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var source: Output<String>? = null

    /**
     * @param value The description of the IP group.
     */
    @JvmName("xmdemsomkthqstch")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The IP address range, in CIDR notation, e.g., `10.0.0.0/16`
     */
    @JvmName("fkimjkesixqljjgq")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value The description of the IP group.
     */
    @JvmName("pbaxgiwybmqrrxep")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The IP address range, in CIDR notation, e.g., `10.0.0.0/16`
     */
    @JvmName("otonbodqvpoqpapy")
    public suspend fun source(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    internal fun build(): IpGroupRuleArgs = IpGroupRuleArgs(
        description = description,
        source = source ?: throw PulumiNullFieldException("source"),
    )
}
