@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin.inputs

import com.pulumi.aws.workspaces.inputs.WorkspaceWorkspacePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property computeTypeName The compute type. For more information, see [Amazon WorkSpaces Bundles](http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles). Valid values are `VALUE`, `STANDARD`, `PERFORMANCE`, `POWER`, `GRAPHICS`, `POWERPRO`, `GRAPHICSPRO`, `GRAPHICS_G4DN`, and `GRAPHICSPRO_G4DN`.
 * @property rootVolumeSizeGib The size of the root volume.
 * @property runningMode The running mode. For more information, see [Manage the WorkSpace Running Mode](https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html). Valid values are `AUTO_STOP` and `ALWAYS_ON`.
 * @property runningModeAutoStopTimeoutInMinutes The time after a user logs off when WorkSpaces are automatically stopped. Configured in 60-minute intervals.
 * @property userVolumeSizeGib The size of the user storage.
 */
public data class WorkspaceWorkspacePropertiesArgs(
    public val computeTypeName: Output<String>? = null,
    public val rootVolumeSizeGib: Output<Int>? = null,
    public val runningMode: Output<String>? = null,
    public val runningModeAutoStopTimeoutInMinutes: Output<Int>? = null,
    public val userVolumeSizeGib: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.workspaces.inputs.WorkspaceWorkspacePropertiesArgs> {
    override fun toJava(): com.pulumi.aws.workspaces.inputs.WorkspaceWorkspacePropertiesArgs =
        com.pulumi.aws.workspaces.inputs.WorkspaceWorkspacePropertiesArgs.builder()
            .computeTypeName(computeTypeName?.applyValue({ args0 -> args0 }))
            .rootVolumeSizeGib(rootVolumeSizeGib?.applyValue({ args0 -> args0 }))
            .runningMode(runningMode?.applyValue({ args0 -> args0 }))
            .runningModeAutoStopTimeoutInMinutes(
                runningModeAutoStopTimeoutInMinutes?.applyValue({ args0 ->
                    args0
                }),
            )
            .userVolumeSizeGib(userVolumeSizeGib?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceWorkspacePropertiesArgs].
 */
@PulumiTagMarker
public class WorkspaceWorkspacePropertiesArgsBuilder internal constructor() {
    private var computeTypeName: Output<String>? = null

    private var rootVolumeSizeGib: Output<Int>? = null

    private var runningMode: Output<String>? = null

    private var runningModeAutoStopTimeoutInMinutes: Output<Int>? = null

    private var userVolumeSizeGib: Output<Int>? = null

    /**
     * @param value The compute type. For more information, see [Amazon WorkSpaces Bundles](http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles). Valid values are `VALUE`, `STANDARD`, `PERFORMANCE`, `POWER`, `GRAPHICS`, `POWERPRO`, `GRAPHICSPRO`, `GRAPHICS_G4DN`, and `GRAPHICSPRO_G4DN`.
     */
    @JvmName("wulcrmjicnhhcqlu")
    public suspend fun computeTypeName(`value`: Output<String>) {
        this.computeTypeName = value
    }

    /**
     * @param value The size of the root volume.
     */
    @JvmName("kshuywxfgfhothjy")
    public suspend fun rootVolumeSizeGib(`value`: Output<Int>) {
        this.rootVolumeSizeGib = value
    }

    /**
     * @param value The running mode. For more information, see [Manage the WorkSpace Running Mode](https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html). Valid values are `AUTO_STOP` and `ALWAYS_ON`.
     */
    @JvmName("ijuoudmnhbbhnwmf")
    public suspend fun runningMode(`value`: Output<String>) {
        this.runningMode = value
    }

    /**
     * @param value The time after a user logs off when WorkSpaces are automatically stopped. Configured in 60-minute intervals.
     */
    @JvmName("arctsuwgwwgwfppp")
    public suspend fun runningModeAutoStopTimeoutInMinutes(`value`: Output<Int>) {
        this.runningModeAutoStopTimeoutInMinutes = value
    }

    /**
     * @param value The size of the user storage.
     */
    @JvmName("gedfjijincymvdho")
    public suspend fun userVolumeSizeGib(`value`: Output<Int>) {
        this.userVolumeSizeGib = value
    }

    /**
     * @param value The compute type. For more information, see [Amazon WorkSpaces Bundles](http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles). Valid values are `VALUE`, `STANDARD`, `PERFORMANCE`, `POWER`, `GRAPHICS`, `POWERPRO`, `GRAPHICSPRO`, `GRAPHICS_G4DN`, and `GRAPHICSPRO_G4DN`.
     */
    @JvmName("uhyerglqlgwwebvr")
    public suspend fun computeTypeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeTypeName = mapped
    }

    /**
     * @param value The size of the root volume.
     */
    @JvmName("cqeielpyrxextapm")
    public suspend fun rootVolumeSizeGib(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootVolumeSizeGib = mapped
    }

    /**
     * @param value The running mode. For more information, see [Manage the WorkSpace Running Mode](https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html). Valid values are `AUTO_STOP` and `ALWAYS_ON`.
     */
    @JvmName("vwtemytmrhhpkhvs")
    public suspend fun runningMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runningMode = mapped
    }

    /**
     * @param value The time after a user logs off when WorkSpaces are automatically stopped. Configured in 60-minute intervals.
     */
    @JvmName("iaaegnaqheytsfng")
    public suspend fun runningModeAutoStopTimeoutInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runningModeAutoStopTimeoutInMinutes = mapped
    }

    /**
     * @param value The size of the user storage.
     */
    @JvmName("cdqlrhdhwfunobto")
    public suspend fun userVolumeSizeGib(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userVolumeSizeGib = mapped
    }

    internal fun build(): WorkspaceWorkspacePropertiesArgs = WorkspaceWorkspacePropertiesArgs(
        computeTypeName = computeTypeName,
        rootVolumeSizeGib = rootVolumeSizeGib,
        runningMode = runningMode,
        runningModeAutoStopTimeoutInMinutes = runningModeAutoStopTimeoutInMinutes,
        userVolumeSizeGib = userVolumeSizeGib,
    )
}
