@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property changeComputeType Whether WorkSpaces directory users can change the compute type (bundle) for their workspace. Default `false`.
 * @property increaseVolumeSize Whether WorkSpaces directory users can increase the volume size of the drives on their workspace. Default `false`.
 * @property rebuildWorkspace Whether WorkSpaces directory users can rebuild the operating system of a workspace to its original state. Default `false`.
 * @property restartWorkspace Whether WorkSpaces directory users can restart their workspace. Default `true`.
 * @property switchRunningMode Whether WorkSpaces directory users can switch the running mode of their workspace. Default `false`.
 */
public data class DirectorySelfServicePermissions(
    public val changeComputeType: Boolean? = null,
    public val increaseVolumeSize: Boolean? = null,
    public val rebuildWorkspace: Boolean? = null,
    public val restartWorkspace: Boolean? = null,
    public val switchRunningMode: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.workspaces.outputs.DirectorySelfServicePermissions):
            DirectorySelfServicePermissions = DirectorySelfServicePermissions(
            changeComputeType = javaType.changeComputeType().map({ args0 -> args0 }).orElse(null),
            increaseVolumeSize = javaType.increaseVolumeSize().map({ args0 -> args0 }).orElse(null),
            rebuildWorkspace = javaType.rebuildWorkspace().map({ args0 -> args0 }).orElse(null),
            restartWorkspace = javaType.restartWorkspace().map({ args0 -> args0 }).orElse(null),
            switchRunningMode = javaType.switchRunningMode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
