@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deviceTypeAndroid Indicates whether users can use Android devices to access their WorkSpaces.
 * @property deviceTypeChromeos Indicates whether users can use Chromebooks to access their WorkSpaces.
 * @property deviceTypeIos Indicates whether users can use iOS devices to access their WorkSpaces.
 * @property deviceTypeLinux Indicates whether users can use Linux clients to access their WorkSpaces.
 * @property deviceTypeOsx Indicates whether users can use macOS clients to access their WorkSpaces.
 * @property deviceTypeWeb Indicates whether users can access their WorkSpaces through a web browser.
 * @property deviceTypeWindows Indicates whether users can use Windows clients to access their WorkSpaces.
 * @property deviceTypeZeroclient Indicates whether users can use zero client devices to access their WorkSpaces.
 */
public data class DirectoryWorkspaceAccessProperties(
    public val deviceTypeAndroid: String? = null,
    public val deviceTypeChromeos: String? = null,
    public val deviceTypeIos: String? = null,
    public val deviceTypeLinux: String? = null,
    public val deviceTypeOsx: String? = null,
    public val deviceTypeWeb: String? = null,
    public val deviceTypeWindows: String? = null,
    public val deviceTypeZeroclient: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.workspaces.outputs.DirectoryWorkspaceAccessProperties):
            DirectoryWorkspaceAccessProperties = DirectoryWorkspaceAccessProperties(
            deviceTypeAndroid = javaType.deviceTypeAndroid().map({ args0 -> args0 }).orElse(null),
            deviceTypeChromeos = javaType.deviceTypeChromeos().map({ args0 -> args0 }).orElse(null),
            deviceTypeIos = javaType.deviceTypeIos().map({ args0 -> args0 }).orElse(null),
            deviceTypeLinux = javaType.deviceTypeLinux().map({ args0 -> args0 }).orElse(null),
            deviceTypeOsx = javaType.deviceTypeOsx().map({ args0 -> args0 }).orElse(null),
            deviceTypeWeb = javaType.deviceTypeWeb().map({ args0 -> args0 }).orElse(null),
            deviceTypeWindows = javaType.deviceTypeWindows().map({ args0 -> args0 }).orElse(null),
            deviceTypeZeroclient = javaType.deviceTypeZeroclient().map({ args0 -> args0 }).orElse(null),
        )
    }
}
