@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBundle.
 * @property bundleId The ID of the bundle.
 * @property computeTypes The compute type. See supported fields below.
 * @property description The description of the bundle.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Name of the compute type.
 * @property owner The owner of the bundle.
 * @property rootStorages The root volume. See supported fields below.
 * @property userStorages The user storage. See supported fields below.
 */
public data class GetBundleResult(
    public val bundleId: String? = null,
    public val computeTypes: List<GetBundleComputeType>,
    public val description: String,
    public val id: String,
    public val name: String? = null,
    public val owner: String? = null,
    public val rootStorages: List<GetBundleRootStorage>,
    public val userStorages: List<GetBundleUserStorage>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.workspaces.outputs.GetBundleResult):
            GetBundleResult = GetBundleResult(
            bundleId = javaType.bundleId().map({ args0 -> args0 }).orElse(null),
            computeTypes = javaType.computeTypes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.workspaces.kotlin.outputs.GetBundleComputeType.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            owner = javaType.owner().map({ args0 -> args0 }).orElse(null),
            rootStorages = javaType.rootStorages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.workspaces.kotlin.outputs.GetBundleRootStorage.Companion.toKotlin(args0)
                })
            }),
            userStorages = javaType.userStorages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.workspaces.kotlin.outputs.GetBundleUserStorage.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
