@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getImage.
 * @property description The description of the image.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property imageId
 * @property name The name of the image.
 * @property operatingSystemType
 * @property requiredTenancy Specifies whether the image is running on dedicated hardware. When Bring Your Own License (BYOL) is enabled, this value is set to DEDICATED. For more information, see [Bring Your Own Windows Desktop Images](https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
 * @property state The status of the image.
 */
public data class GetImageResult(
    public val description: String,
    public val id: String,
    public val imageId: String,
    public val name: String,
    public val operatingSystemType: String,
    public val requiredTenancy: String,
    public val state: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.workspaces.outputs.GetImageResult): GetImageResult =
            GetImageResult(
                description = javaType.description(),
                id = javaType.id(),
                imageId = javaType.imageId(),
                name = javaType.name(),
                operatingSystemType = javaType.operatingSystemType(),
                requiredTenancy = javaType.requiredTenancy(),
                state = javaType.state(),
            )
    }
}
