@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getWorkspace.
 * @property bundleId
 * @property computerName Name of the WorkSpace, as seen by the operating system.
 * @property directoryId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ipAddress IP address of the WorkSpace.
 * @property rootVolumeEncryptionEnabled
 * @property state Operational state of the WorkSpace.
 * @property tags
 * @property userName
 * @property userVolumeEncryptionEnabled
 * @property volumeEncryptionKey
 * @property workspaceId
 * @property workspaceProperties
 */
public data class GetWorkspaceResult(
    public val bundleId: String,
    public val computerName: String,
    public val directoryId: String,
    public val id: String,
    public val ipAddress: String,
    public val rootVolumeEncryptionEnabled: Boolean,
    public val state: String,
    public val tags: Map<String, String>,
    public val userName: String,
    public val userVolumeEncryptionEnabled: Boolean,
    public val volumeEncryptionKey: String,
    public val workspaceId: String,
    public val workspaceProperties: List<GetWorkspaceWorkspaceProperty>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.workspaces.outputs.GetWorkspaceResult):
            GetWorkspaceResult = GetWorkspaceResult(
            bundleId = javaType.bundleId(),
            computerName = javaType.computerName(),
            directoryId = javaType.directoryId(),
            id = javaType.id(),
            ipAddress = javaType.ipAddress(),
            rootVolumeEncryptionEnabled = javaType.rootVolumeEncryptionEnabled(),
            state = javaType.state(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            userName = javaType.userName(),
            userVolumeEncryptionEnabled = javaType.userVolumeEncryptionEnabled(),
            volumeEncryptionKey = javaType.volumeEncryptionKey(),
            workspaceId = javaType.workspaceId(),
            workspaceProperties = javaType.workspaceProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.workspaces.kotlin.outputs.GetWorkspaceWorkspaceProperty.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
