@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property computeTypeName Compute type. For more information, see [Amazon WorkSpaces Bundles](http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles). Valid values are `VALUE`, `STANDARD`, `PERFORMANCE`, `POWER`, `GRAPHICS`, `POWERPRO` and `GRAPHICSPRO`.
 * @property rootVolumeSizeGib Size of the root volume.
 * @property runningMode Running mode. For more information, see [Manage the WorkSpace Running Mode](https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html). Valid values are `AUTO_STOP` and `ALWAYS_ON`.
 * @property runningModeAutoStopTimeoutInMinutes Time after a user logs off when WorkSpaces are automatically stopped. Configured in 60-minute intervals.
 * @property userVolumeSizeGib Size of the user storage.
 */
public data class GetWorkspaceWorkspaceProperty(
    public val computeTypeName: String,
    public val rootVolumeSizeGib: Int,
    public val runningMode: String,
    public val runningModeAutoStopTimeoutInMinutes: Int,
    public val userVolumeSizeGib: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.workspaces.outputs.GetWorkspaceWorkspaceProperty):
            GetWorkspaceWorkspaceProperty = GetWorkspaceWorkspaceProperty(
            computeTypeName = javaType.computeTypeName(),
            rootVolumeSizeGib = javaType.rootVolumeSizeGib(),
            runningMode = javaType.runningMode(),
            runningModeAutoStopTimeoutInMinutes = javaType.runningModeAutoStopTimeoutInMinutes(),
            userVolumeSizeGib = javaType.userVolumeSizeGib(),
        )
    }
}
