@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The description of the IP group.
 * @property source The IP address range, in CIDR notation, e.g., `10.0.0.0/16`
 */
public data class IpGroupRule(
    public val description: String? = null,
    public val source: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.workspaces.outputs.IpGroupRule): IpGroupRule =
            IpGroupRule(
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                source = javaType.source(),
            )
    }
}
