@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property computeTypeName The compute type. For more information, see [Amazon WorkSpaces Bundles](http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles). Valid values are `VALUE`, `STANDARD`, `PERFORMANCE`, `POWER`, `GRAPHICS`, `POWERPRO`, `GRAPHICSPRO`, `GRAPHICS_G4DN`, and `GRAPHICSPRO_G4DN`.
 * @property rootVolumeSizeGib The size of the root volume.
 * @property runningMode The running mode. For more information, see [Manage the WorkSpace Running Mode](https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html). Valid values are `AUTO_STOP` and `ALWAYS_ON`.
 * @property runningModeAutoStopTimeoutInMinutes The time after a user logs off when WorkSpaces are automatically stopped. Configured in 60-minute intervals.
 * @property userVolumeSizeGib The size of the user storage.
 */
public data class WorkspaceWorkspaceProperties(
    public val computeTypeName: String? = null,
    public val rootVolumeSizeGib: Int? = null,
    public val runningMode: String? = null,
    public val runningModeAutoStopTimeoutInMinutes: Int? = null,
    public val userVolumeSizeGib: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.workspaces.outputs.WorkspaceWorkspaceProperties):
            WorkspaceWorkspaceProperties = WorkspaceWorkspaceProperties(
            computeTypeName = javaType.computeTypeName().map({ args0 -> args0 }).orElse(null),
            rootVolumeSizeGib = javaType.rootVolumeSizeGib().map({ args0 -> args0 }).orElse(null),
            runningMode = javaType.runningMode().map({ args0 -> args0 }).orElse(null),
            runningModeAutoStopTimeoutInMinutes = javaType.runningModeAutoStopTimeoutInMinutes().map({ args0 ->
                args0
            }).orElse(null),
            userVolumeSizeGib = javaType.userVolumeSizeGib().map({ args0 -> args0 }).orElse(null),
        )
    }
}
