@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.xray.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EncryptionConfig].
 */
@PulumiTagMarker
public class EncryptionConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EncryptionConfigArgs = EncryptionConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EncryptionConfigArgsBuilder.() -> Unit) {
        val builder = EncryptionConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EncryptionConfig {
        val builtJavaResource = com.pulumi.aws.xray.EncryptionConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EncryptionConfig(builtJavaResource)
    }
}

/**
 * Creates and manages an AWS XRay Encryption Config.
 * > **NOTE:** Removing this resource from the provider has no effect to the encryption configuration within X-Ray.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.xray.EncryptionConfig;
 * import com.pulumi.aws.xray.EncryptionConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EncryptionConfig("example", EncryptionConfigArgs.builder()
 *             .type("NONE")
 *             .build());
 *     }
 * }
 * ```
 * ### With KMS Key
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.xray.EncryptionConfig;
 * import com.pulumi.aws.xray.EncryptionConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("Enable IAM User Permissions")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers(String.format("arn:aws:iam::%s:root", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                     .build())
 *                 .actions("kms:*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("Some Key")
 *             .deletionWindowInDays(7)
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleEncryptionConfig = new EncryptionConfig("exampleEncryptionConfig", EncryptionConfigArgs.builder()
 *             .type("KMS")
 *             .keyId(exampleKey.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import XRay Encryption Config using the region name. For example:
 * ```sh
 *  $ pulumi import aws:xray/encryptionConfig:EncryptionConfig example us-west-2
 * ```
 *
 */
public class EncryptionConfig internal constructor(
    override val javaResource: com.pulumi.aws.xray.EncryptionConfig,
) : KotlinCustomResource(javaResource, EncryptionConfigMapper) {
    /**
     * An AWS KMS customer master key (CMK) ARN.
     */
    public val keyId: Output<String>?
        get() = javaResource.keyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of encryption. Set to `KMS` to use your own key for encryption. Set to `NONE` for default encryption.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EncryptionConfigMapper : ResourceMapper<EncryptionConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.xray.EncryptionConfig::class == javaResource::class

    override fun map(javaResource: Resource): EncryptionConfig = EncryptionConfig(
        javaResource as
            com.pulumi.aws.xray.EncryptionConfig,
    )
}

/**
 * @see [EncryptionConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EncryptionConfig].
 */
public suspend fun encryptionConfig(
    name: String,
    block: suspend EncryptionConfigResourceBuilder.() -> Unit,
): EncryptionConfig {
    val builder = EncryptionConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EncryptionConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun encryptionConfig(name: String): EncryptionConfig {
    val builder = EncryptionConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
