@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.xray.kotlin

import com.pulumi.aws.xray.EncryptionConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates and manages an AWS XRay Encryption Config.
 * > **NOTE:** Removing this resource from the provider has no effect to the encryption configuration within X-Ray.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.xray.EncryptionConfig;
 * import com.pulumi.aws.xray.EncryptionConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EncryptionConfig("example", EncryptionConfigArgs.builder()
 *             .type("NONE")
 *             .build());
 *     }
 * }
 * ```
 * ### With KMS Key
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.xray.EncryptionConfig;
 * import com.pulumi.aws.xray.EncryptionConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("Enable IAM User Permissions")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers(String.format("arn:aws:iam::%s:root", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                     .build())
 *                 .actions("kms:*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("Some Key")
 *             .deletionWindowInDays(7)
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleEncryptionConfig = new EncryptionConfig("exampleEncryptionConfig", EncryptionConfigArgs.builder()
 *             .type("KMS")
 *             .keyId(exampleKey.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import XRay Encryption Config using the region name. For example:
 * ```sh
 *  $ pulumi import aws:xray/encryptionConfig:EncryptionConfig example us-west-2
 * ```
 * @property keyId An AWS KMS customer master key (CMK) ARN.
 * @property type The type of encryption. Set to `KMS` to use your own key for encryption. Set to `NONE` for default encryption.
 */
public data class EncryptionConfigArgs(
    public val keyId: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.xray.EncryptionConfigArgs> {
    override fun toJava(): com.pulumi.aws.xray.EncryptionConfigArgs =
        com.pulumi.aws.xray.EncryptionConfigArgs.builder()
            .keyId(keyId?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EncryptionConfigArgs].
 */
@PulumiTagMarker
public class EncryptionConfigArgsBuilder internal constructor() {
    private var keyId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value An AWS KMS customer master key (CMK) ARN.
     */
    @JvmName("diufiybxmtlrsrtm")
    public suspend fun keyId(`value`: Output<String>) {
        this.keyId = value
    }

    /**
     * @param value The type of encryption. Set to `KMS` to use your own key for encryption. Set to `NONE` for default encryption.
     */
    @JvmName("gvehxyfldcmtpooj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value An AWS KMS customer master key (CMK) ARN.
     */
    @JvmName("mldvowasjupgpybo")
    public suspend fun keyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyId = mapped
    }

    /**
     * @param value The type of encryption. Set to `KMS` to use your own key for encryption. Set to `NONE` for default encryption.
     */
    @JvmName("crjgolfyuyktyyay")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EncryptionConfigArgs = EncryptionConfigArgs(
        keyId = keyId,
        type = type,
    )
}
