@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.xray.kotlin

import com.pulumi.aws.xray.kotlin.outputs.GroupInsightsConfiguration
import com.pulumi.aws.xray.kotlin.outputs.GroupInsightsConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Group].
 */
@PulumiTagMarker
public class GroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupArgs = GroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupArgsBuilder.() -> Unit) {
        val builder = GroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Group {
        val builtJavaResource = com.pulumi.aws.xray.Group(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Group(builtJavaResource)
    }
}

/**
 * Creates and manages an AWS XRay Group.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.xray.Group;
 * import com.pulumi.aws.xray.GroupArgs;
 * import com.pulumi.aws.xray.inputs.GroupInsightsConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Group("example", GroupArgs.builder()
 *             .filterExpression("responsetime > 5")
 *             .groupName("example")
 *             .insightsConfiguration(GroupInsightsConfigurationArgs.builder()
 *                 .insightsEnabled(true)
 *                 .notificationsEnabled(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import XRay Groups using the ARN. For example:
 * ```sh
 *  $ pulumi import aws:xray/group:Group example arn:aws:xray:us-west-2:1234567890:group/example-group/TNGX7SW5U6QY36T4ZMOUA3HVLBYCZTWDIOOXY3CJAXTHSS3YCWUA
 * ```
 *
 */
public class Group internal constructor(
    override val javaResource: com.pulumi.aws.xray.Group,
) : KotlinCustomResource(javaResource, GroupMapper) {
    /**
     * The ARN of the Group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The filter expression defining criteria by which to group traces. more info can be found in official [docs](https://docs.aws.amazon.com/xray/latest/devguide/xray-console-filters.html).
     */
    public val filterExpression: Output<String>
        get() = javaResource.filterExpression().applyValue({ args0 -> args0 })

    /**
     * The name of the group.
     */
    public val groupName: Output<String>
        get() = javaResource.groupName().applyValue({ args0 -> args0 })

    /**
     * Configuration options for enabling insights.
     */
    public val insightsConfiguration: Output<GroupInsightsConfiguration>
        get() = javaResource.insightsConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object GroupMapper : ResourceMapper<Group> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.xray.Group::class == javaResource::class

    override fun map(javaResource: Resource): Group = Group(javaResource as com.pulumi.aws.xray.Group)
}

/**
 * @see [Group].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Group].
 */
public suspend fun group(name: String, block: suspend GroupResourceBuilder.() -> Unit): Group {
    val builder = GroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Group].
 * @param name The _unique_ name of the resulting resource.
 */
public fun group(name: String): Group {
    val builder = GroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
