@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.xray.kotlin

import com.pulumi.aws.xray.GroupArgs.builder
import com.pulumi.aws.xray.kotlin.inputs.GroupInsightsConfigurationArgs
import com.pulumi.aws.xray.kotlin.inputs.GroupInsightsConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates and manages an AWS XRay Group.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.xray.Group;
 * import com.pulumi.aws.xray.GroupArgs;
 * import com.pulumi.aws.xray.inputs.GroupInsightsConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Group("example", GroupArgs.builder()
 *             .filterExpression("responsetime > 5")
 *             .groupName("example")
 *             .insightsConfiguration(GroupInsightsConfigurationArgs.builder()
 *                 .insightsEnabled(true)
 *                 .notificationsEnabled(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import XRay Groups using the ARN. For example:
 * ```sh
 *  $ pulumi import aws:xray/group:Group example arn:aws:xray:us-west-2:1234567890:group/example-group/TNGX7SW5U6QY36T4ZMOUA3HVLBYCZTWDIOOXY3CJAXTHSS3YCWUA
 * ```
 * @property filterExpression The filter expression defining criteria by which to group traces. more info can be found in official [docs](https://docs.aws.amazon.com/xray/latest/devguide/xray-console-filters.html).
 * @property groupName The name of the group.
 * @property insightsConfiguration Configuration options for enabling insights.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
 */
public data class GroupArgs(
    public val filterExpression: Output<String>? = null,
    public val groupName: Output<String>? = null,
    public val insightsConfiguration: Output<GroupInsightsConfigurationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.xray.GroupArgs> {
    override fun toJava(): com.pulumi.aws.xray.GroupArgs = com.pulumi.aws.xray.GroupArgs.builder()
        .filterExpression(filterExpression?.applyValue({ args0 -> args0 }))
        .groupName(groupName?.applyValue({ args0 -> args0 }))
        .insightsConfiguration(
            insightsConfiguration?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [GroupArgs].
 */
@PulumiTagMarker
public class GroupArgsBuilder internal constructor() {
    private var filterExpression: Output<String>? = null

    private var groupName: Output<String>? = null

    private var insightsConfiguration: Output<GroupInsightsConfigurationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The filter expression defining criteria by which to group traces. more info can be found in official [docs](https://docs.aws.amazon.com/xray/latest/devguide/xray-console-filters.html).
     */
    @JvmName("yxaaoaldmetsnvxq")
    public suspend fun filterExpression(`value`: Output<String>) {
        this.filterExpression = value
    }

    /**
     * @param value The name of the group.
     */
    @JvmName("wsyihatxnmbfiill")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value Configuration options for enabling insights.
     */
    @JvmName("lckjivvscxrorbee")
    public suspend fun insightsConfiguration(`value`: Output<GroupInsightsConfigurationArgs>) {
        this.insightsConfiguration = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("uwwwmseqvwtgbmhv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The filter expression defining criteria by which to group traces. more info can be found in official [docs](https://docs.aws.amazon.com/xray/latest/devguide/xray-console-filters.html).
     */
    @JvmName("qlajfvmosggyqkmf")
    public suspend fun filterExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterExpression = mapped
    }

    /**
     * @param value The name of the group.
     */
    @JvmName("dmbbsrfjasfmpigh")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value Configuration options for enabling insights.
     */
    @JvmName("tiewpuryuluhyrgv")
    public suspend fun insightsConfiguration(`value`: GroupInsightsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.insightsConfiguration = mapped
    }

    /**
     * @param argument Configuration options for enabling insights.
     */
    @JvmName("obxiiemwqvcahkrn")
    public suspend
    fun insightsConfiguration(argument: suspend GroupInsightsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = GroupInsightsConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.insightsConfiguration = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("yjhcniidvudpnjqu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("handfirpddfqhdia")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): GroupArgs = GroupArgs(
        filterExpression = filterExpression,
        groupName = groupName,
        insightsConfiguration = insightsConfiguration,
        tags = tags,
    )
}
