@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.xray.kotlin

import com.pulumi.aws.xray.SamplingRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates and manages an AWS XRay Sampling Rule.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.xray.SamplingRule;
 * import com.pulumi.aws.xray.SamplingRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SamplingRule("example", SamplingRuleArgs.builder()
 *             .attributes(Map.of("Hello", "Tris"))
 *             .fixedRate(0.05)
 *             .host("*")
 *             .httpMethod("*")
 *             .priority(9999)
 *             .reservoirSize(1)
 *             .resourceArn("*")
 *             .ruleName("example")
 *             .serviceName("*")
 *             .serviceType("*")
 *             .urlPath("*")
 *             .version(1)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import XRay Sampling Rules using the name. For example:
 * ```sh
 *  $ pulumi import aws:xray/samplingRule:SamplingRule example example
 * ```
 * @property attributes Matches attributes derived from the request.
 * @property fixedRate The percentage of matching requests to instrument, after the reservoir is exhausted.
 * @property host Matches the hostname from a request URL.
 * @property httpMethod Matches the HTTP method of a request.
 * @property priority The priority of the sampling rule.
 * @property reservoirSize A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.
 * @property resourceArn Matches the ARN of the AWS resource on which the service runs.
 * @property ruleName The name of the sampling rule.
 * @property serviceName Matches the `name` that the service uses to identify itself in segments.
 * @property serviceType Matches the `origin` that the service uses to identify its type in segments.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
 * @property urlPath Matches the path from a request URL.
 * @property version The version of the sampling rule format (`1` )
 */
public data class SamplingRuleArgs(
    public val attributes: Output<Map<String, String>>? = null,
    public val fixedRate: Output<Double>? = null,
    public val host: Output<String>? = null,
    public val httpMethod: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val reservoirSize: Output<Int>? = null,
    public val resourceArn: Output<String>? = null,
    public val ruleName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val serviceType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val urlPath: Output<String>? = null,
    public val version: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.xray.SamplingRuleArgs> {
    override fun toJava(): com.pulumi.aws.xray.SamplingRuleArgs =
        com.pulumi.aws.xray.SamplingRuleArgs.builder()
            .attributes(
                attributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .fixedRate(fixedRate?.applyValue({ args0 -> args0 }))
            .host(host?.applyValue({ args0 -> args0 }))
            .httpMethod(httpMethod?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .reservoirSize(reservoirSize?.applyValue({ args0 -> args0 }))
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .serviceType(serviceType?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .urlPath(urlPath?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SamplingRuleArgs].
 */
@PulumiTagMarker
public class SamplingRuleArgsBuilder internal constructor() {
    private var attributes: Output<Map<String, String>>? = null

    private var fixedRate: Output<Double>? = null

    private var host: Output<String>? = null

    private var httpMethod: Output<String>? = null

    private var priority: Output<Int>? = null

    private var reservoirSize: Output<Int>? = null

    private var resourceArn: Output<String>? = null

    private var ruleName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var serviceType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var urlPath: Output<String>? = null

    private var version: Output<Int>? = null

    /**
     * @param value Matches attributes derived from the request.
     */
    @JvmName("xngynxxqrobopddj")
    public suspend fun attributes(`value`: Output<Map<String, String>>) {
        this.attributes = value
    }

    /**
     * @param value The percentage of matching requests to instrument, after the reservoir is exhausted.
     */
    @JvmName("ljekgonumjyptvkr")
    public suspend fun fixedRate(`value`: Output<Double>) {
        this.fixedRate = value
    }

    /**
     * @param value Matches the hostname from a request URL.
     */
    @JvmName("dqloitmbhsvmnhfa")
    public suspend fun host(`value`: Output<String>) {
        this.host = value
    }

    /**
     * @param value Matches the HTTP method of a request.
     */
    @JvmName("rgocggamwxasqdlg")
    public suspend fun httpMethod(`value`: Output<String>) {
        this.httpMethod = value
    }

    /**
     * @param value The priority of the sampling rule.
     */
    @JvmName("ijxfgbymyffpncva")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.
     */
    @JvmName("fodtnjehshangjkv")
    public suspend fun reservoirSize(`value`: Output<Int>) {
        this.reservoirSize = value
    }

    /**
     * @param value Matches the ARN of the AWS resource on which the service runs.
     */
    @JvmName("apocyhnoyqbwwqqu")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value The name of the sampling rule.
     */
    @JvmName("msbivutdugsoahbp")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value Matches the `name` that the service uses to identify itself in segments.
     */
    @JvmName("lwcqpanjukmgpqrv")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Matches the `origin` that the service uses to identify its type in segments.
     */
    @JvmName("dytwijsajihnpghq")
    public suspend fun serviceType(`value`: Output<String>) {
        this.serviceType = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("xrcefkytwoedwcpw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Matches the path from a request URL.
     */
    @JvmName("hdqvfxwrsfdxiugd")
    public suspend fun urlPath(`value`: Output<String>) {
        this.urlPath = value
    }

    /**
     * @param value The version of the sampling rule format (`1` )
     */
    @JvmName("dxkfdpxwcibsmuic")
    public suspend fun version(`value`: Output<Int>) {
        this.version = value
    }

    /**
     * @param value Matches attributes derived from the request.
     */
    @JvmName("wjgnydpwjhxbawob")
    public suspend fun attributes(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param values Matches attributes derived from the request.
     */
    @JvmName("paprxucdlcwygxsg")
    public fun attributes(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param value The percentage of matching requests to instrument, after the reservoir is exhausted.
     */
    @JvmName("cgthxwxmaoxrlrvc")
    public suspend fun fixedRate(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fixedRate = mapped
    }

    /**
     * @param value Matches the hostname from a request URL.
     */
    @JvmName("tdkpqyjstmvddsvd")
    public suspend fun host(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value Matches the HTTP method of a request.
     */
    @JvmName("grbdgnwutvdjueox")
    public suspend fun httpMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpMethod = mapped
    }

    /**
     * @param value The priority of the sampling rule.
     */
    @JvmName("ahgpgvxemyfmckai")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.
     */
    @JvmName("bnhvlkuqrnvkkwts")
    public suspend fun reservoirSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reservoirSize = mapped
    }

    /**
     * @param value Matches the ARN of the AWS resource on which the service runs.
     */
    @JvmName("uqugfmtbrpovsvof")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    /**
     * @param value The name of the sampling rule.
     */
    @JvmName("uqqwefmmtmfwxvix")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value Matches the `name` that the service uses to identify itself in segments.
     */
    @JvmName("yvgykpprjcicwecb")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Matches the `origin` that the service uses to identify its type in segments.
     */
    @JvmName("wthroofufhonimij")
    public suspend fun serviceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceType = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("hrapcmyjuxldifcq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("wpsxfdorklnlvfpf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Matches the path from a request URL.
     */
    @JvmName("ivhbawxblditgxdp")
    public suspend fun urlPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.urlPath = mapped
    }

    /**
     * @param value The version of the sampling rule format (`1` )
     */
    @JvmName("pcugihfeubugalbu")
    public suspend fun version(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): SamplingRuleArgs = SamplingRuleArgs(
        attributes = attributes,
        fixedRate = fixedRate,
        host = host,
        httpMethod = httpMethod,
        priority = priority,
        reservoirSize = reservoirSize,
        resourceArn = resourceArn,
        ruleName = ruleName,
        serviceName = serviceName,
        serviceType = serviceType,
        tags = tags,
        urlPath = urlPath,
        version = version,
    )
}
