@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.xray.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property insightsEnabled Specifies whether insights are enabled.
 * @property notificationsEnabled Specifies whether insight notifications are enabled.
 */
public data class GroupInsightsConfiguration(
    public val insightsEnabled: Boolean,
    public val notificationsEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.xray.outputs.GroupInsightsConfiguration):
            GroupInsightsConfiguration = GroupInsightsConfiguration(
            insightsEnabled = javaType.insightsEnabled(),
            notificationsEnabled = javaType.notificationsEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
