@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.accessanalyzer.kotlin

import com.pulumi.aws.accessanalyzer.kotlin.outputs.AnalyzerConfiguration
import com.pulumi.aws.accessanalyzer.kotlin.outputs.AnalyzerConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Analyzer].
 */
@PulumiTagMarker
public class AnalyzerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AnalyzerArgs = AnalyzerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AnalyzerArgsBuilder.() -> Unit) {
        val builder = AnalyzerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Analyzer {
        val builtJavaResource = com.pulumi.aws.accessanalyzer.Analyzer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Analyzer(builtJavaResource)
    }
}

/**
 * Manages an Access Analyzer Analyzer. More information can be found in the [Access Analyzer User Guide](https://docs.aws.amazon.com/IAM/latest/UserGuide/what-is-access-analyzer.html).
 * ## Example Usage
 * ### Account Analyzer
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.accessanalyzer.Analyzer("example", {analyzerName: "example"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.accessanalyzer.Analyzer("example", analyzer_name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AccessAnalyzer.Analyzer("example", new()
 *     {
 *         AnalyzerName = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/accessanalyzer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := accessanalyzer.NewAnalyzer(ctx, "example", &accessanalyzer.AnalyzerArgs{
 * 			AnalyzerName: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.accessanalyzer.Analyzer;
 * import com.pulumi.aws.accessanalyzer.AnalyzerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Analyzer("example", AnalyzerArgs.builder()
 *             .analyzerName("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:accessanalyzer:Analyzer
 *     properties:
 *       analyzerName: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Organization Analyzer
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.organizations.Organization("example", {awsServiceAccessPrincipals: ["access-analyzer&#46;amazonaws&#46;com"]});
 * const exampleAnalyzer = new aws.accessanalyzer.Analyzer("example", {
 *     analyzerName: "example",
 *     type: "ORGANIZATION",
 * }, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.organizations.Organization("example", aws_service_access_principals=["access-analyzer&#46;amazonaws&#46;com"])
 * example_analyzer = aws.accessanalyzer.Analyzer("example",
 *     analyzer_name="example",
 *     type="ORGANIZATION",
 *     opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Organizations.Organization("example", new()
 *     {
 *         AwsServiceAccessPrincipals = new[]
 *         {
 *             "access-analyzer.amazonaws.com",
 *         },
 *     });
 *     var exampleAnalyzer = new Aws.AccessAnalyzer.Analyzer("example", new()
 *     {
 *         AnalyzerName = "example",
 *         Type = "ORGANIZATION",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/accessanalyzer"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/organizations"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := organizations.NewOrganization(ctx, "example", &organizations.OrganizationArgs{
 * 			AwsServiceAccessPrincipals: pulumi.StringArray{
 * 				pulumi.String("access-analyzer.amazonaws.com"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = accessanalyzer.NewAnalyzer(ctx, "example", &accessanalyzer.AnalyzerArgs{
 * 			AnalyzerName: pulumi.String("example"),
 * 			Type:         pulumi.String("ORGANIZATION"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.Organization;
 * import com.pulumi.aws.organizations.OrganizationArgs;
 * import com.pulumi.aws.accessanalyzer.Analyzer;
 * import com.pulumi.aws.accessanalyzer.AnalyzerArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Organization("example", OrganizationArgs.builder()
 *             .awsServiceAccessPrincipals("access-analyzer.amazonaws.com")
 *             .build());
 *         var exampleAnalyzer = new Analyzer("exampleAnalyzer", AnalyzerArgs.builder()
 *             .analyzerName("example")
 *             .type("ORGANIZATION")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:organizations:Organization
 *     properties:
 *       awsServiceAccessPrincipals:
 *         - access-analyzer.amazonaws.com
 *   exampleAnalyzer:
 *     type: aws:accessanalyzer:Analyzer
 *     name: example
 *     properties:
 *       analyzerName: example
 *       type: ORGANIZATION
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Access Analyzer Analyzers using the `analyzer_name`. For example:
 * ```sh
 * $ pulumi import aws:accessanalyzer/analyzer:Analyzer example example
 * ```
 */
public class Analyzer internal constructor(
    override val javaResource: com.pulumi.aws.accessanalyzer.Analyzer,
) : KotlinCustomResource(javaResource, AnalyzerMapper) {
    /**
     * Name of the Analyzer.
     * The following arguments are optional:
     */
    public val analyzerName: Output<String>
        get() = javaResource.analyzerName().applyValue({ args0 -> args0 })

    /**
     * ARN of the Analyzer.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A block that specifies the configuration of the analyzer. Documented below
     */
    public val configuration: Output<AnalyzerConfiguration>?
        get() = javaResource.configuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Type of Analyzer. Valid values are `ACCOUNT`, `ORGANIZATION`, `ACCOUNT_UNUSED_ACCESS `, `ORGANIZATION_UNUSED_ACCESS`. Defaults to `ACCOUNT`.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object AnalyzerMapper : ResourceMapper<Analyzer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.accessanalyzer.Analyzer::class == javaResource::class

    override fun map(javaResource: Resource): Analyzer = Analyzer(
        javaResource as
            com.pulumi.aws.accessanalyzer.Analyzer,
    )
}

/**
 * @see [Analyzer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Analyzer].
 */
public suspend fun analyzer(name: String, block: suspend AnalyzerResourceBuilder.() -> Unit): Analyzer {
    val builder = AnalyzerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Analyzer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun analyzer(name: String): Analyzer {
    val builder = AnalyzerResourceBuilder()
    builder.name(name)
    return builder.build()
}
