@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.accessanalyzer.kotlin

import com.pulumi.aws.accessanalyzer.kotlin.outputs.ArchiveRuleFilter
import com.pulumi.aws.accessanalyzer.kotlin.outputs.ArchiveRuleFilter.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ArchiveRule].
 */
@PulumiTagMarker
public class ArchiveRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ArchiveRuleArgs = ArchiveRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ArchiveRuleArgsBuilder.() -> Unit) {
        val builder = ArchiveRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ArchiveRule {
        val builtJavaResource = com.pulumi.aws.accessanalyzer.ArchiveRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ArchiveRule(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS AccessAnalyzer Archive Rule.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.accessanalyzer.ArchiveRule("example", {
 *     analyzerName: "example-analyzer",
 *     ruleName: "example-rule",
 *     filters: [
 *         {
 *             criteria: "condition.aws:UserId",
 *             eqs: ["userid"],
 *         },
 *         {
 *             criteria: "error",
 *             exists: "true",
 *         },
 *         {
 *             criteria: "isPublic",
 *             eqs: ["false"],
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.accessanalyzer.ArchiveRule("example",
 *     analyzer_name="example-analyzer",
 *     rule_name="example-rule",
 *     filters=[
 *         {
 *             "criteria": "condition.aws:UserId",
 *             "eqs": ["userid"],
 *         },
 *         {
 *             "criteria": "error",
 *             "exists": "true",
 *         },
 *         {
 *             "criteria": "isPublic",
 *             "eqs": ["false"],
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AccessAnalyzer.ArchiveRule("example", new()
 *     {
 *         AnalyzerName = "example-analyzer",
 *         RuleName = "example-rule",
 *         Filters = new[]
 *         {
 *             new Aws.AccessAnalyzer.Inputs.ArchiveRuleFilterArgs
 *             {
 *                 Criteria = "condition.aws:UserId",
 *                 Eqs = new[]
 *                 {
 *                     "userid",
 *                 },
 *             },
 *             new Aws.AccessAnalyzer.Inputs.ArchiveRuleFilterArgs
 *             {
 *                 Criteria = "error",
 *                 Exists = "true",
 *             },
 *             new Aws.AccessAnalyzer.Inputs.ArchiveRuleFilterArgs
 *             {
 *                 Criteria = "isPublic",
 *                 Eqs = new[]
 *                 {
 *                     "false",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/accessanalyzer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := accessanalyzer.NewArchiveRule(ctx, "example", &accessanalyzer.ArchiveRuleArgs{
 * 			AnalyzerName: pulumi.String("example-analyzer"),
 * 			RuleName:     pulumi.String("example-rule"),
 * 			Filters: accessanalyzer.ArchiveRuleFilterArray{
 * 				&accessanalyzer.ArchiveRuleFilterArgs{
 * 					Criteria: pulumi.String("condition.aws:UserId"),
 * 					Eqs: pulumi.StringArray{
 * 						pulumi.String("userid"),
 * 					},
 * 				},
 * 				&accessanalyzer.ArchiveRuleFilterArgs{
 * 					Criteria: pulumi.String("error"),
 * 					Exists:   pulumi.String("true"),
 * 				},
 * 				&accessanalyzer.ArchiveRuleFilterArgs{
 * 					Criteria: pulumi.String("isPublic"),
 * 					Eqs: pulumi.StringArray{
 * 						pulumi.String("false"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.accessanalyzer.ArchiveRule;
 * import com.pulumi.aws.accessanalyzer.ArchiveRuleArgs;
 * import com.pulumi.aws.accessanalyzer.inputs.ArchiveRuleFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ArchiveRule("example", ArchiveRuleArgs.builder()
 *             .analyzerName("example-analyzer")
 *             .ruleName("example-rule")
 *             .filters(
 *                 ArchiveRuleFilterArgs.builder()
 *                     .criteria("condition.aws:UserId")
 *                     .eqs("userid")
 *                     .build(),
 *                 ArchiveRuleFilterArgs.builder()
 *                     .criteria("error")
 *                     .exists(true)
 *                     .build(),
 *                 ArchiveRuleFilterArgs.builder()
 *                     .criteria("isPublic")
 *                     .eqs("false")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:accessanalyzer:ArchiveRule
 *     properties:
 *       analyzerName: example-analyzer
 *       ruleName: example-rule
 *       filters:
 *         - criteria: condition.aws:UserId
 *           eqs:
 *             - userid
 *         - criteria: error
 *           exists: true
 *         - criteria: isPublic
 *           eqs:
 *             - 'false'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AccessAnalyzer ArchiveRule using the `analyzer_name/rule_name`. For example:
 * ```sh
 * $ pulumi import aws:accessanalyzer/archiveRule:ArchiveRule example example-analyzer/example-rule
 * ```
 */
public class ArchiveRule internal constructor(
    override val javaResource: com.pulumi.aws.accessanalyzer.ArchiveRule,
) : KotlinCustomResource(javaResource, ArchiveRuleMapper) {
    /**
     * Analyzer name.
     */
    public val analyzerName: Output<String>
        get() = javaResource.analyzerName().applyValue({ args0 -> args0 })

    /**
     * Filter criteria for the archive rule. See Filter for more details.
     */
    public val filters: Output<List<ArchiveRuleFilter>>
        get() = javaResource.filters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Rule name.
     */
    public val ruleName: Output<String>
        get() = javaResource.ruleName().applyValue({ args0 -> args0 })
}

public object ArchiveRuleMapper : ResourceMapper<ArchiveRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.accessanalyzer.ArchiveRule::class == javaResource::class

    override fun map(javaResource: Resource): ArchiveRule = ArchiveRule(
        javaResource as
            com.pulumi.aws.accessanalyzer.ArchiveRule,
    )
}

/**
 * @see [ArchiveRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ArchiveRule].
 */
public suspend fun archiveRule(name: String, block: suspend ArchiveRuleResourceBuilder.() -> Unit): ArchiveRule {
    val builder = ArchiveRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ArchiveRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun archiveRule(name: String): ArchiveRule {
    val builder = ArchiveRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
