@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.accessanalyzer.kotlin

import com.pulumi.aws.accessanalyzer.ArchiveRuleArgs.builder
import com.pulumi.aws.accessanalyzer.kotlin.inputs.ArchiveRuleFilterArgs
import com.pulumi.aws.accessanalyzer.kotlin.inputs.ArchiveRuleFilterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS AccessAnalyzer Archive Rule.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.accessanalyzer.ArchiveRule("example", {
 *     analyzerName: "example-analyzer",
 *     ruleName: "example-rule",
 *     filters: [
 *         {
 *             criteria: "condition.aws:UserId",
 *             eqs: ["userid"],
 *         },
 *         {
 *             criteria: "error",
 *             exists: "true",
 *         },
 *         {
 *             criteria: "isPublic",
 *             eqs: ["false"],
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.accessanalyzer.ArchiveRule("example",
 *     analyzer_name="example-analyzer",
 *     rule_name="example-rule",
 *     filters=[
 *         {
 *             "criteria": "condition.aws:UserId",
 *             "eqs": ["userid"],
 *         },
 *         {
 *             "criteria": "error",
 *             "exists": "true",
 *         },
 *         {
 *             "criteria": "isPublic",
 *             "eqs": ["false"],
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AccessAnalyzer.ArchiveRule("example", new()
 *     {
 *         AnalyzerName = "example-analyzer",
 *         RuleName = "example-rule",
 *         Filters = new[]
 *         {
 *             new Aws.AccessAnalyzer.Inputs.ArchiveRuleFilterArgs
 *             {
 *                 Criteria = "condition.aws:UserId",
 *                 Eqs = new[]
 *                 {
 *                     "userid",
 *                 },
 *             },
 *             new Aws.AccessAnalyzer.Inputs.ArchiveRuleFilterArgs
 *             {
 *                 Criteria = "error",
 *                 Exists = "true",
 *             },
 *             new Aws.AccessAnalyzer.Inputs.ArchiveRuleFilterArgs
 *             {
 *                 Criteria = "isPublic",
 *                 Eqs = new[]
 *                 {
 *                     "false",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/accessanalyzer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := accessanalyzer.NewArchiveRule(ctx, "example", &accessanalyzer.ArchiveRuleArgs{
 * 			AnalyzerName: pulumi.String("example-analyzer"),
 * 			RuleName:     pulumi.String("example-rule"),
 * 			Filters: accessanalyzer.ArchiveRuleFilterArray{
 * 				&accessanalyzer.ArchiveRuleFilterArgs{
 * 					Criteria: pulumi.String("condition.aws:UserId"),
 * 					Eqs: pulumi.StringArray{
 * 						pulumi.String("userid"),
 * 					},
 * 				},
 * 				&accessanalyzer.ArchiveRuleFilterArgs{
 * 					Criteria: pulumi.String("error"),
 * 					Exists:   pulumi.String("true"),
 * 				},
 * 				&accessanalyzer.ArchiveRuleFilterArgs{
 * 					Criteria: pulumi.String("isPublic"),
 * 					Eqs: pulumi.StringArray{
 * 						pulumi.String("false"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.accessanalyzer.ArchiveRule;
 * import com.pulumi.aws.accessanalyzer.ArchiveRuleArgs;
 * import com.pulumi.aws.accessanalyzer.inputs.ArchiveRuleFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ArchiveRule("example", ArchiveRuleArgs.builder()
 *             .analyzerName("example-analyzer")
 *             .ruleName("example-rule")
 *             .filters(
 *                 ArchiveRuleFilterArgs.builder()
 *                     .criteria("condition.aws:UserId")
 *                     .eqs("userid")
 *                     .build(),
 *                 ArchiveRuleFilterArgs.builder()
 *                     .criteria("error")
 *                     .exists(true)
 *                     .build(),
 *                 ArchiveRuleFilterArgs.builder()
 *                     .criteria("isPublic")
 *                     .eqs("false")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:accessanalyzer:ArchiveRule
 *     properties:
 *       analyzerName: example-analyzer
 *       ruleName: example-rule
 *       filters:
 *         - criteria: condition.aws:UserId
 *           eqs:
 *             - userid
 *         - criteria: error
 *           exists: true
 *         - criteria: isPublic
 *           eqs:
 *             - 'false'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AccessAnalyzer ArchiveRule using the `analyzer_name/rule_name`. For example:
 * ```sh
 * $ pulumi import aws:accessanalyzer/archiveRule:ArchiveRule example example-analyzer/example-rule
 * ```
 * @property analyzerName Analyzer name.
 * @property filters Filter criteria for the archive rule. See Filter for more details.
 * @property ruleName Rule name.
 */
public data class ArchiveRuleArgs(
    public val analyzerName: Output<String>? = null,
    public val filters: Output<List<ArchiveRuleFilterArgs>>? = null,
    public val ruleName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.accessanalyzer.ArchiveRuleArgs> {
    override fun toJava(): com.pulumi.aws.accessanalyzer.ArchiveRuleArgs =
        com.pulumi.aws.accessanalyzer.ArchiveRuleArgs.builder()
            .analyzerName(analyzerName?.applyValue({ args0 -> args0 }))
            .filters(
                filters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ruleName(ruleName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ArchiveRuleArgs].
 */
@PulumiTagMarker
public class ArchiveRuleArgsBuilder internal constructor() {
    private var analyzerName: Output<String>? = null

    private var filters: Output<List<ArchiveRuleFilterArgs>>? = null

    private var ruleName: Output<String>? = null

    /**
     * @param value Analyzer name.
     */
    @JvmName("koxcwwrlqxogsqqh")
    public suspend fun analyzerName(`value`: Output<String>) {
        this.analyzerName = value
    }

    /**
     * @param value Filter criteria for the archive rule. See Filter for more details.
     */
    @JvmName("exiunkjrlgpsfstj")
    public suspend fun filters(`value`: Output<List<ArchiveRuleFilterArgs>>) {
        this.filters = value
    }

    @JvmName("gilbvadvnsmkmrut")
    public suspend fun filters(vararg values: Output<ArchiveRuleFilterArgs>) {
        this.filters = Output.all(values.asList())
    }

    /**
     * @param values Filter criteria for the archive rule. See Filter for more details.
     */
    @JvmName("tksqxwhohvqwxdtf")
    public suspend fun filters(values: List<Output<ArchiveRuleFilterArgs>>) {
        this.filters = Output.all(values)
    }

    /**
     * @param value Rule name.
     */
    @JvmName("psivyyxqsiqwvuqx")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value Analyzer name.
     */
    @JvmName("evkqbnjtqojkinjv")
    public suspend fun analyzerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.analyzerName = mapped
    }

    /**
     * @param value Filter criteria for the archive rule. See Filter for more details.
     */
    @JvmName("xlodcrumdfuetjjj")
    public suspend fun filters(`value`: List<ArchiveRuleFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param argument Filter criteria for the archive rule. See Filter for more details.
     */
    @JvmName("vuxcdxlisbtqtnue")
    public suspend fun filters(argument: List<suspend ArchiveRuleFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ArchiveRuleFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument Filter criteria for the archive rule. See Filter for more details.
     */
    @JvmName("comtjheovosvklci")
    public suspend fun filters(vararg argument: suspend ArchiveRuleFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ArchiveRuleFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument Filter criteria for the archive rule. See Filter for more details.
     */
    @JvmName("tqdhwlthgpsnmnvg")
    public suspend fun filters(argument: suspend ArchiveRuleFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ArchiveRuleFilterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param values Filter criteria for the archive rule. See Filter for more details.
     */
    @JvmName("gbmdvonetiygvave")
    public suspend fun filters(vararg values: ArchiveRuleFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param value Rule name.
     */
    @JvmName("nwycumkjrgwffcgi")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    internal fun build(): ArchiveRuleArgs = ArchiveRuleArgs(
        analyzerName = analyzerName,
        filters = filters,
        ruleName = ruleName,
    )
}
