@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.accessanalyzer.kotlin.inputs

import com.pulumi.aws.accessanalyzer.inputs.AnalyzerConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property unusedAccess A block that specifies the configuration of an unused access analyzer for an AWS organization or account. Documented below
 */
public data class AnalyzerConfigurationArgs(
    public val unusedAccess: Output<AnalyzerConfigurationUnusedAccessArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.accessanalyzer.inputs.AnalyzerConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.accessanalyzer.inputs.AnalyzerConfigurationArgs =
        com.pulumi.aws.accessanalyzer.inputs.AnalyzerConfigurationArgs.builder()
            .unusedAccess(unusedAccess?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AnalyzerConfigurationArgs].
 */
@PulumiTagMarker
public class AnalyzerConfigurationArgsBuilder internal constructor() {
    private var unusedAccess: Output<AnalyzerConfigurationUnusedAccessArgs>? = null

    /**
     * @param value A block that specifies the configuration of an unused access analyzer for an AWS organization or account. Documented below
     */
    @JvmName("sgqlbmlawfvikpvp")
    public suspend fun unusedAccess(`value`: Output<AnalyzerConfigurationUnusedAccessArgs>) {
        this.unusedAccess = value
    }

    /**
     * @param value A block that specifies the configuration of an unused access analyzer for an AWS organization or account. Documented below
     */
    @JvmName("cfueywbgvkhefbog")
    public suspend fun unusedAccess(`value`: AnalyzerConfigurationUnusedAccessArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unusedAccess = mapped
    }

    /**
     * @param argument A block that specifies the configuration of an unused access analyzer for an AWS organization or account. Documented below
     */
    @JvmName("lcxvooepeiimxcjr")
    public suspend fun unusedAccess(argument: suspend AnalyzerConfigurationUnusedAccessArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyzerConfigurationUnusedAccessArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.unusedAccess = mapped
    }

    internal fun build(): AnalyzerConfigurationArgs = AnalyzerConfigurationArgs(
        unusedAccess = unusedAccess,
    )
}
