@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.accessanalyzer.kotlin.inputs

import com.pulumi.aws.accessanalyzer.inputs.AnalyzerConfigurationUnusedAccessArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property unusedAccessAge The specified access age in days for which to generate findings for unused access.
 */
public data class AnalyzerConfigurationUnusedAccessArgs(
    public val unusedAccessAge: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.accessanalyzer.inputs.AnalyzerConfigurationUnusedAccessArgs> {
    override fun toJava(): com.pulumi.aws.accessanalyzer.inputs.AnalyzerConfigurationUnusedAccessArgs = com.pulumi.aws.accessanalyzer.inputs.AnalyzerConfigurationUnusedAccessArgs.builder()
        .unusedAccessAge(unusedAccessAge?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalyzerConfigurationUnusedAccessArgs].
 */
@PulumiTagMarker
public class AnalyzerConfigurationUnusedAccessArgsBuilder internal constructor() {
    private var unusedAccessAge: Output<Int>? = null

    /**
     * @param value The specified access age in days for which to generate findings for unused access.
     */
    @JvmName("xyjpypaxkvbkpkdx")
    public suspend fun unusedAccessAge(`value`: Output<Int>) {
        this.unusedAccessAge = value
    }

    /**
     * @param value The specified access age in days for which to generate findings for unused access.
     */
    @JvmName("fuwutaycjdpgxbij")
    public suspend fun unusedAccessAge(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unusedAccessAge = mapped
    }

    internal fun build(): AnalyzerConfigurationUnusedAccessArgs =
        AnalyzerConfigurationUnusedAccessArgs(
            unusedAccessAge = unusedAccessAge,
        )
}
