@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.accessanalyzer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property contains Contains comparator.
 * @property criteria Filter criteria.
 * @property eqs Equals comparator.
 * @property exists Boolean comparator.
 * @property neqs Not Equals comparator.
 */
public data class ArchiveRuleFilter(
    public val contains: List<String>? = null,
    public val criteria: String,
    public val eqs: List<String>? = null,
    public val exists: String? = null,
    public val neqs: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.accessanalyzer.outputs.ArchiveRuleFilter): ArchiveRuleFilter = ArchiveRuleFilter(
            contains = javaType.contains().map({ args0 -> args0 }),
            criteria = javaType.criteria(),
            eqs = javaType.eqs().map({ args0 -> args0 }),
            exists = javaType.exists().map({ args0 -> args0 }).orElse(null),
            neqs = javaType.neqs().map({ args0 -> args0 }),
        )
    }
}
