@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.account.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AlternativeContact].
 */
@PulumiTagMarker
public class AlternativeContactResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AlternativeContactArgs = AlternativeContactArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AlternativeContactArgsBuilder.() -> Unit) {
        val builder = AlternativeContactArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AlternativeContact {
        val builtJavaResource = com.pulumi.aws.account.AlternativeContact(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AlternativeContact(builtJavaResource)
    }
}

/**
 * Manages the specified alternate contact attached to an AWS Account.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const operations = new aws.account.AlternativeContact("operations", {
 *     alternateContactType: "OPERATIONS",
 *     name: "Example",
 *     title: "Example",
 *     emailAddress: "test@example.com",
 *     phoneNumber: "+1234567890",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * operations = aws.account.AlternativeContact("operations",
 *     alternate_contact_type="OPERATIONS",
 *     name="Example",
 *     title="Example",
 *     email_address="test@example.com",
 *     phone_number="+1234567890")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var operations = new Aws.Account.AlternativeContact("operations", new()
 *     {
 *         AlternateContactType = "OPERATIONS",
 *         Name = "Example",
 *         Title = "Example",
 *         EmailAddress = "test@example.com",
 *         PhoneNumber = "+1234567890",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/account"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := account.NewAlternativeContact(ctx, "operations", &account.AlternativeContactArgs{
 * 			AlternateContactType: pulumi.String("OPERATIONS"),
 * 			Name:                 pulumi.String("Example"),
 * 			Title:                pulumi.String("Example"),
 * 			EmailAddress:         pulumi.String("test@example.com"),
 * 			PhoneNumber:          pulumi.String("+1234567890"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.account.AlternativeContact;
 * import com.pulumi.aws.account.AlternativeContactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var operations = new AlternativeContact("operations", AlternativeContactArgs.builder()
 *             .alternateContactType("OPERATIONS")
 *             .name("Example")
 *             .title("Example")
 *             .emailAddress("test@example.com")
 *             .phoneNumber("+1234567890")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   operations:
 *     type: aws:account:AlternativeContact
 *     properties:
 *       alternateContactType: OPERATIONS
 *       name: Example
 *       title: Example
 *       emailAddress: test@example.com
 *       phoneNumber: '+1234567890'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Import the Alternate Contact for another account using the `account_id` and `alternate_contact_type` separated by a forward slash (`/`):
 * __Using `pulumi import` to import__ the Alternate Contact for the current or another account using the `alternate_contact_type`. For example:
 * Import the Alternate Contact for the current account:
 * ```sh
 * $ pulumi import aws:account/alternativeContact:AlternativeContact operations OPERATIONS
 * ```
 * Import the Alternate Contact for another account using the `account_id` and `alternate_contact_type` separated by a forward slash (`/`):
 * ```sh
 * $ pulumi import aws:account/alternativeContact:AlternativeContact operations 1234567890/OPERATIONS
 * ```
 */
public class AlternativeContact internal constructor(
    override val javaResource: com.pulumi.aws.account.AlternativeContact,
) : KotlinCustomResource(javaResource, AlternativeContactMapper) {
    /**
     * ID of the target account when managing member accounts. Will manage current user's account by default if omitted.
     */
    public val accountId: Output<String>?
        get() = javaResource.accountId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Type of the alternate contact. Allowed values are: `BILLING`, `OPERATIONS`, `SECURITY`.
     */
    public val alternateContactType: Output<String>
        get() = javaResource.alternateContactType().applyValue({ args0 -> args0 })

    /**
     * An email address for the alternate contact.
     */
    public val emailAddress: Output<String>
        get() = javaResource.emailAddress().applyValue({ args0 -> args0 })

    /**
     * Name of the alternate contact.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Phone number for the alternate contact.
     */
    public val phoneNumber: Output<String>
        get() = javaResource.phoneNumber().applyValue({ args0 -> args0 })

    /**
     * Title for the alternate contact.
     */
    public val title: Output<String>
        get() = javaResource.title().applyValue({ args0 -> args0 })
}

public object AlternativeContactMapper : ResourceMapper<AlternativeContact> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.account.AlternativeContact::class == javaResource::class

    override fun map(javaResource: Resource): AlternativeContact = AlternativeContact(
        javaResource as
            com.pulumi.aws.account.AlternativeContact,
    )
}

/**
 * @see [AlternativeContact].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AlternativeContact].
 */
public suspend fun alternativeContact(
    name: String,
    block: suspend AlternativeContactResourceBuilder.() -> Unit,
): AlternativeContact {
    val builder = AlternativeContactResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AlternativeContact].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alternativeContact(name: String): AlternativeContact {
    val builder = AlternativeContactResourceBuilder()
    builder.name(name)
    return builder.build()
}
