@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.account.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PrimaryContact].
 */
@PulumiTagMarker
public class PrimaryContactResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrimaryContactArgs = PrimaryContactArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrimaryContactArgsBuilder.() -> Unit) {
        val builder = PrimaryContactArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrimaryContact {
        val builtJavaResource = com.pulumi.aws.account.PrimaryContact(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PrimaryContact(builtJavaResource)
    }
}

/**
 * Manages the specified primary contact information associated with an AWS Account.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.account.PrimaryContact("test", {
 *     addressLine1: "123 Any Street",
 *     city: "Seattle",
 *     companyName: "Example Corp, Inc.",
 *     countryCode: "US",
 *     districtOrCounty: "King",
 *     fullName: "My Name",
 *     phoneNumber: "+64211111111",
 *     postalCode: "98101",
 *     stateOrRegion: "WA",
 *     websiteUrl: "https://www.examplecorp.com",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.account.PrimaryContact("test",
 *     address_line1="123 Any Street",
 *     city="Seattle",
 *     company_name="Example Corp, Inc.",
 *     country_code="US",
 *     district_or_county="King",
 *     full_name="My Name",
 *     phone_number="+64211111111",
 *     postal_code="98101",
 *     state_or_region="WA",
 *     website_url="https://www.examplecorp.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Account.PrimaryContact("test", new()
 *     {
 *         AddressLine1 = "123 Any Street",
 *         City = "Seattle",
 *         CompanyName = "Example Corp, Inc.",
 *         CountryCode = "US",
 *         DistrictOrCounty = "King",
 *         FullName = "My Name",
 *         PhoneNumber = "+64211111111",
 *         PostalCode = "98101",
 *         StateOrRegion = "WA",
 *         WebsiteUrl = "https://www.examplecorp.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/account"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := account.NewPrimaryContact(ctx, "test", &account.PrimaryContactArgs{
 * 			AddressLine1:     pulumi.String("123 Any Street"),
 * 			City:             pulumi.String("Seattle"),
 * 			CompanyName:      pulumi.String("Example Corp, Inc."),
 * 			CountryCode:      pulumi.String("US"),
 * 			DistrictOrCounty: pulumi.String("King"),
 * 			FullName:         pulumi.String("My Name"),
 * 			PhoneNumber:      pulumi.String("+64211111111"),
 * 			PostalCode:       pulumi.String("98101"),
 * 			StateOrRegion:    pulumi.String("WA"),
 * 			WebsiteUrl:       pulumi.String("https://www.examplecorp.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.account.PrimaryContact;
 * import com.pulumi.aws.account.PrimaryContactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new PrimaryContact("test", PrimaryContactArgs.builder()
 *             .addressLine1("123 Any Street")
 *             .city("Seattle")
 *             .companyName("Example Corp, Inc.")
 *             .countryCode("US")
 *             .districtOrCounty("King")
 *             .fullName("My Name")
 *             .phoneNumber("+64211111111")
 *             .postalCode("98101")
 *             .stateOrRegion("WA")
 *             .websiteUrl("https://www.examplecorp.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:account:PrimaryContact
 *     properties:
 *       addressLine1: 123 Any Street
 *       city: Seattle
 *       companyName: Example Corp, Inc.
 *       countryCode: US
 *       districtOrCounty: King
 *       fullName: My Name
 *       phoneNumber: '+64211111111'
 *       postalCode: '98101'
 *       stateOrRegion: WA
 *       websiteUrl: https://www.examplecorp.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import the Primary Contact using the `account_id`. For example:
 * ```sh
 * $ pulumi import aws:account/primaryContact:PrimaryContact test 1234567890
 * ```
 */
public class PrimaryContact internal constructor(
    override val javaResource: com.pulumi.aws.account.PrimaryContact,
) : KotlinCustomResource(javaResource, PrimaryContactMapper) {
    /**
     * The ID of the target account when managing member accounts. Will manage current user's account by default if omitted.
     */
    public val accountId: Output<String>?
        get() = javaResource.accountId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The first line of the primary contact address.
     */
    public val addressLine1: Output<String>
        get() = javaResource.addressLine1().applyValue({ args0 -> args0 })

    /**
     * The second line of the primary contact address, if any.
     */
    public val addressLine2: Output<String>?
        get() = javaResource.addressLine2().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The third line of the primary contact address, if any.
     */
    public val addressLine3: Output<String>?
        get() = javaResource.addressLine3().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The city of the primary contact address.
     */
    public val city: Output<String>
        get() = javaResource.city().applyValue({ args0 -> args0 })

    /**
     * The name of the company associated with the primary contact information, if any.
     */
    public val companyName: Output<String>?
        get() = javaResource.companyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ISO-3166 two-letter country code for the primary contact address.
     */
    public val countryCode: Output<String>
        get() = javaResource.countryCode().applyValue({ args0 -> args0 })

    /**
     * The district or county of the primary contact address, if any.
     */
    public val districtOrCounty: Output<String>?
        get() = javaResource.districtOrCounty().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The full name of the primary contact address.
     */
    public val fullName: Output<String>
        get() = javaResource.fullName().applyValue({ args0 -> args0 })

    /**
     * The phone number of the primary contact information. The number will be validated and, in some countries, checked for activation.
     */
    public val phoneNumber: Output<String>
        get() = javaResource.phoneNumber().applyValue({ args0 -> args0 })

    /**
     * The postal code of the primary contact address.
     */
    public val postalCode: Output<String>
        get() = javaResource.postalCode().applyValue({ args0 -> args0 })

    /**
     * The state or region of the primary contact address. This field is required in selected countries.
     */
    public val stateOrRegion: Output<String>?
        get() = javaResource.stateOrRegion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The URL of the website associated with the primary contact information, if any.
     */
    public val websiteUrl: Output<String>?
        get() = javaResource.websiteUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object PrimaryContactMapper : ResourceMapper<PrimaryContact> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.account.PrimaryContact::class == javaResource::class

    override fun map(javaResource: Resource): PrimaryContact = PrimaryContact(
        javaResource as
            com.pulumi.aws.account.PrimaryContact,
    )
}

/**
 * @see [PrimaryContact].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrimaryContact].
 */
public suspend fun primaryContact(
    name: String,
    block: suspend PrimaryContactResourceBuilder.() -> Unit,
): PrimaryContact {
    val builder = PrimaryContactResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrimaryContact].
 * @param name The _unique_ name of the resulting resource.
 */
public fun primaryContact(name: String): PrimaryContact {
    val builder = PrimaryContactResourceBuilder()
    builder.name(name)
    return builder.build()
}
