@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.account.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Region].
 */
@PulumiTagMarker
public class RegionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegionArgs = RegionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegionArgsBuilder.() -> Unit) {
        val builder = RegionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Region {
        val builtJavaResource = com.pulumi.aws.account.Region(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Region(builtJavaResource)
    }
}

/**
 * Enable (Opt-In) or Disable (Opt-Out) a particular Region for an AWS account.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.account.Region("example", {
 *     regionName: "ap-southeast-3",
 *     enabled: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.account.Region("example",
 *     region_name="ap-southeast-3",
 *     enabled=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Account.Region("example", new()
 *     {
 *         RegionName = "ap-southeast-3",
 *         Enabled = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/account"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := account.NewRegion(ctx, "example", &account.RegionArgs{
 * 			RegionName: pulumi.String("ap-southeast-3"),
 * 			Enabled:    pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.account.Region;
 * import com.pulumi.aws.account.RegionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Region("example", RegionArgs.builder()
 *             .regionName("ap-southeast-3")
 *             .enabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:account:Region
 *     properties:
 *       regionName: ap-southeast-3
 *       enabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`. For example:
 * ```sh
 * $ pulumi import aws:account/region:Region example ap-southeast-3
 * ```
 */
public class Region internal constructor(
    override val javaResource: com.pulumi.aws.account.Region,
) : KotlinCustomResource(javaResource, RegionMapper) {
    /**
     * The ID of the target account when managing member accounts. Will manage current user's account by default if omitted. To use this parameter, the caller must be an identity in the organization's management account or a delegated administrator account. The specified account ID must also be a member account in the same organization. The organization must have all features enabled, and the organization must have trusted access enabled for the Account Management service, and optionally a delegated admin account assigned.
     */
    public val accountId: Output<String>?
        get() = javaResource.accountId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether the region is enabled.
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * The region opt status.
     */
    public val optStatus: Output<String>
        get() = javaResource.optStatus().applyValue({ args0 -> args0 })

    /**
     * The region name to manage.
     */
    public val regionName: Output<String>
        get() = javaResource.regionName().applyValue({ args0 -> args0 })
}

public object RegionMapper : ResourceMapper<Region> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.account.Region::class == javaResource::class

    override fun map(javaResource: Resource): Region = Region(
        javaResource as
            com.pulumi.aws.account.Region,
    )
}

/**
 * @see [Region].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Region].
 */
public suspend fun region(name: String, block: suspend RegionResourceBuilder.() -> Unit): Region {
    val builder = RegionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Region].
 * @param name The _unique_ name of the resulting resource.
 */
public fun region(name: String): Region {
    val builder = RegionResourceBuilder()
    builder.name(name)
    return builder.build()
}
