@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.account.kotlin

import com.pulumi.aws.account.RegionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Enable (Opt-In) or Disable (Opt-Out) a particular Region for an AWS account.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.account.Region("example", {
 *     regionName: "ap-southeast-3",
 *     enabled: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.account.Region("example",
 *     region_name="ap-southeast-3",
 *     enabled=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Account.Region("example", new()
 *     {
 *         RegionName = "ap-southeast-3",
 *         Enabled = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/account"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := account.NewRegion(ctx, "example", &account.RegionArgs{
 * 			RegionName: pulumi.String("ap-southeast-3"),
 * 			Enabled:    pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.account.Region;
 * import com.pulumi.aws.account.RegionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Region("example", RegionArgs.builder()
 *             .regionName("ap-southeast-3")
 *             .enabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:account:Region
 *     properties:
 *       regionName: ap-southeast-3
 *       enabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`. For example:
 * ```sh
 * $ pulumi import aws:account/region:Region example ap-southeast-3
 * ```
 * @property accountId The ID of the target account when managing member accounts. Will manage current user's account by default if omitted. To use this parameter, the caller must be an identity in the organization's management account or a delegated administrator account. The specified account ID must also be a member account in the same organization. The organization must have all features enabled, and the organization must have trusted access enabled for the Account Management service, and optionally a delegated admin account assigned.
 * @property enabled Whether the region is enabled.
 * @property regionName The region name to manage.
 */
public data class RegionArgs(
    public val accountId: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val regionName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.account.RegionArgs> {
    override fun toJava(): com.pulumi.aws.account.RegionArgs =
        com.pulumi.aws.account.RegionArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .regionName(regionName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegionArgs].
 */
@PulumiTagMarker
public class RegionArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var regionName: Output<String>? = null

    /**
     * @param value The ID of the target account when managing member accounts. Will manage current user's account by default if omitted. To use this parameter, the caller must be an identity in the organization's management account or a delegated administrator account. The specified account ID must also be a member account in the same organization. The organization must have all features enabled, and the organization must have trusted access enabled for the Account Management service, and optionally a delegated admin account assigned.
     */
    @JvmName("cjaycdvgtfxqtwri")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value Whether the region is enabled.
     */
    @JvmName("qhowaisqidgpgqws")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The region name to manage.
     */
    @JvmName("tidolplrldbrpiaq")
    public suspend fun regionName(`value`: Output<String>) {
        this.regionName = value
    }

    /**
     * @param value The ID of the target account when managing member accounts. Will manage current user's account by default if omitted. To use this parameter, the caller must be an identity in the organization's management account or a delegated administrator account. The specified account ID must also be a member account in the same organization. The organization must have all features enabled, and the organization must have trusted access enabled for the Account Management service, and optionally a delegated admin account assigned.
     */
    @JvmName("uldgwpquafwodbrq")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value Whether the region is enabled.
     */
    @JvmName("sqhcjlttxonjrdqq")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The region name to manage.
     */
    @JvmName("eslfbjxivdddolen")
    public suspend fun regionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionName = mapped
    }

    internal fun build(): RegionArgs = RegionArgs(
        accountId = accountId,
        enabled = enabled,
        regionName = regionName,
    )
}
