@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acm.kotlin.inputs

import com.pulumi.aws.acm.inputs.CertificateValidationOptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domainName Fully qualified domain name (FQDN) in the certificate.
 * @property validationDomain Domain name that you want ACM to use to send you validation emails. This domain name is the suffix of the email addresses that you want ACM to use. This must be the same as the `domain_name` value or a superdomain of the `domain_name` value. For example, if you request a certificate for `"testing.example.com"`, you can specify `"example.com"` for this value.
 */
public data class CertificateValidationOptionArgs(
    public val domainName: Output<String>,
    public val validationDomain: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.acm.inputs.CertificateValidationOptionArgs> {
    override fun toJava(): com.pulumi.aws.acm.inputs.CertificateValidationOptionArgs =
        com.pulumi.aws.acm.inputs.CertificateValidationOptionArgs.builder()
            .domainName(domainName.applyValue({ args0 -> args0 }))
            .validationDomain(validationDomain.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateValidationOptionArgs].
 */
@PulumiTagMarker
public class CertificateValidationOptionArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var validationDomain: Output<String>? = null

    /**
     * @param value Fully qualified domain name (FQDN) in the certificate.
     */
    @JvmName("drijdguafipkpnua")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Domain name that you want ACM to use to send you validation emails. This domain name is the suffix of the email addresses that you want ACM to use. This must be the same as the `domain_name` value or a superdomain of the `domain_name` value. For example, if you request a certificate for `"testing.example.com"`, you can specify `"example.com"` for this value.
     */
    @JvmName("efdofyqrssoeibub")
    public suspend fun validationDomain(`value`: Output<String>) {
        this.validationDomain = value
    }

    /**
     * @param value Fully qualified domain name (FQDN) in the certificate.
     */
    @JvmName("fdsghyeyedclskfi")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Domain name that you want ACM to use to send you validation emails. This domain name is the suffix of the email addresses that you want ACM to use. This must be the same as the `domain_name` value or a superdomain of the `domain_name` value. For example, if you request a certificate for `"testing.example.com"`, you can specify `"example.com"` for this value.
     */
    @JvmName("hdecwclfiroiwbpx")
    public suspend fun validationDomain(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validationDomain = mapped
    }

    internal fun build(): CertificateValidationOptionArgs = CertificateValidationOptionArgs(
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        validationDomain = validationDomain ?: throw PulumiNullFieldException("validationDomain"),
    )
}
