@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acm.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getCertificate.
 * @property arn ARN of the found certificate, suitable for referencing in other resources that support ACM certificates.
 * @property certificate ACM-issued certificate.
 * @property certificateChain Certificates forming the requested ACM-issued certificate's chain of trust. The chain consists of the certificate of the issuing CA and the intermediate certificates of any other subordinate CAs.
 * @property domain
 * @property id The provider-assigned unique ID for this managed resource.
 * @property keyTypes
 * @property mostRecent
 * @property status Status of the found certificate.
 * @property statuses
 * @property tags Mapping of tags for the resource.
 * @property types
 */
public data class GetCertificateResult(
    public val arn: String,
    public val certificate: String,
    public val certificateChain: String,
    public val domain: String,
    public val id: String,
    public val keyTypes: List<String>? = null,
    public val mostRecent: Boolean? = null,
    public val status: String,
    public val statuses: List<String>? = null,
    public val tags: Map<String, String>,
    public val types: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.acm.outputs.GetCertificateResult): GetCertificateResult = GetCertificateResult(
            arn = javaType.arn(),
            certificate = javaType.certificate(),
            certificateChain = javaType.certificateChain(),
            domain = javaType.domain(),
            id = javaType.id(),
            keyTypes = javaType.keyTypes().map({ args0 -> args0 }),
            mostRecent = javaType.mostRecent().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
            statuses = javaType.statuses().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            types = javaType.types().map({ args0 -> args0 }),
        )
    }
}
