@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin

import com.pulumi.aws.acmpca.kotlin.outputs.CertificateValidity
import com.pulumi.aws.acmpca.kotlin.outputs.CertificateValidity.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Certificate].
 */
@PulumiTagMarker
public class CertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CertificateArgs = CertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CertificateArgsBuilder.() -> Unit) {
        val builder = CertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Certificate {
        val builtJavaResource = com.pulumi.aws.acmpca.Certificate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Certificate(builtJavaResource)
    }
}

/**
 * Provides a resource to issue a certificate using AWS Certificate Manager Private Certificate Authority (ACM PCA).
 * Certificates created using `aws.acmpca.Certificate` are not eligible for automatic renewal,
 * and must be replaced instead.
 * To issue a renewable certificate using an ACM PCA, create a `aws.acm.Certificate`
 * with the parameter `certificate_authority_arn`.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as tls from "@pulumi/tls";
 * const exampleCertificateAuthority = new aws.acmpca.CertificateAuthority("example", {
 *     certificateAuthorityConfiguration: {
 *         keyAlgorithm: "RSA_4096",
 *         signingAlgorithm: "SHA512WITHRSA",
 *         subject: {
 *             commonName: "example.com",
 *         },
 *     },
 *     permanentDeletionTimeInDays: 7,
 * });
 * const key = new tls.PrivateKey("key", {algorithm: "RSA"});
 * const csr = new tls.CertRequest("csr", {
 *     privateKeyPem: key.privateKeyPem,
 *     subject: {
 *         commonName: "example",
 *     },
 * });
 * const example = new aws.acmpca.Certificate("example", {
 *     certificateAuthorityArn: exampleCertificateAuthority.arn,
 *     certificateSigningRequest: csr.certRequestPem,
 *     signingAlgorithm: "SHA256WITHRSA",
 *     validity: {
 *         type: "YEARS",
 *         value: "1",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_tls as tls
 * example_certificate_authority = aws.acmpca.CertificateAuthority("example",
 *     certificate_authority_configuration={
 *         "key_algorithm": "RSA_4096",
 *         "signing_algorithm": "SHA512WITHRSA",
 *         "subject": {
 *             "common_name": "example.com",
 *         },
 *     },
 *     permanent_deletion_time_in_days=7)
 * key = tls.PrivateKey("key", algorithm="RSA")
 * csr = tls.CertRequest("csr",
 *     private_key_pem=key.private_key_pem,
 *     subject={
 *         "common_name": "example",
 *     })
 * example = aws.acmpca.Certificate("example",
 *     certificate_authority_arn=example_certificate_authority.arn,
 *     certificate_signing_request=csr.cert_request_pem,
 *     signing_algorithm="SHA256WITHRSA",
 *     validity={
 *         "type": "YEARS",
 *         "value": "1",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Tls = Pulumi.Tls;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleCertificateAuthority = new Aws.Acmpca.CertificateAuthority("example", new()
 *     {
 *         CertificateAuthorityConfiguration = new Aws.Acmpca.Inputs.CertificateAuthorityCertificateAuthorityConfigurationArgs
 *         {
 *             KeyAlgorithm = "RSA_4096",
 *             SigningAlgorithm = "SHA512WITHRSA",
 *             Subject = new Aws.Acmpca.Inputs.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs
 *             {
 *                 CommonName = "example.com",
 *             },
 *         },
 *         PermanentDeletionTimeInDays = 7,
 *     });
 *     var key = new Tls.PrivateKey("key", new()
 *     {
 *         Algorithm = "RSA",
 *     });
 *     var csr = new Tls.CertRequest("csr", new()
 *     {
 *         PrivateKeyPem = key.PrivateKeyPem,
 *         Subject = new Tls.Inputs.CertRequestSubjectArgs
 *         {
 *             CommonName = "example",
 *         },
 *     });
 *     var example = new Aws.Acmpca.Certificate("example", new()
 *     {
 *         CertificateAuthorityArn = exampleCertificateAuthority.Arn,
 *         CertificateSigningRequest = csr.CertRequestPem,
 *         SigningAlgorithm = "SHA256WITHRSA",
 *         Validity = new Aws.Acmpca.Inputs.CertificateValidityArgs
 *         {
 *             Type = "YEARS",
 *             Value = "1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/acmpca"
 * 	"github.com/pulumi/pulumi-tls/sdk/v4/go/tls"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleCertificateAuthority, err := acmpca.NewCertificateAuthority(ctx, "example", &acmpca.CertificateAuthorityArgs{
 * 			CertificateAuthorityConfiguration: &acmpca.CertificateAuthorityCertificateAuthorityConfigurationArgs{
 * 				KeyAlgorithm:     pulumi.String("RSA_4096"),
 * 				SigningAlgorithm: pulumi.String("SHA512WITHRSA"),
 * 				Subject: &acmpca.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs{
 * 					CommonName: pulumi.String("example.com"),
 * 				},
 * 			},
 * 			PermanentDeletionTimeInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		key, err := tls.NewPrivateKey(ctx, "key", &tls.PrivateKeyArgs{
 * 			Algorithm: pulumi.String("RSA"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		csr, err := tls.NewCertRequest(ctx, "csr", &tls.CertRequestArgs{
 * 			PrivateKeyPem: key.PrivateKeyPem,
 * 			Subject: &tls.CertRequestSubjectArgs{
 * 				CommonName: pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = acmpca.NewCertificate(ctx, "example", &acmpca.CertificateArgs{
 * 			CertificateAuthorityArn:   exampleCertificateAuthority.Arn,
 * 			CertificateSigningRequest: csr.CertRequestPem,
 * 			SigningAlgorithm:          pulumi.String("SHA256WITHRSA"),
 * 			Validity: &acmpca.CertificateValidityArgs{
 * 				Type:  pulumi.String("YEARS"),
 * 				Value: pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.acmpca.CertificateAuthority;
 * import com.pulumi.aws.acmpca.CertificateAuthorityArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs;
 * import com.pulumi.tls.PrivateKey;
 * import com.pulumi.tls.PrivateKeyArgs;
 * import com.pulumi.tls.CertRequest;
 * import com.pulumi.tls.CertRequestArgs;
 * import com.pulumi.tls.inputs.CertRequestSubjectArgs;
 * import com.pulumi.aws.acmpca.Certificate;
 * import com.pulumi.aws.acmpca.CertificateArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateValidityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCertificateAuthority = new CertificateAuthority("exampleCertificateAuthority", CertificateAuthorityArgs.builder()
 *             .certificateAuthorityConfiguration(CertificateAuthorityCertificateAuthorityConfigurationArgs.builder()
 *                 .keyAlgorithm("RSA_4096")
 *                 .signingAlgorithm("SHA512WITHRSA")
 *                 .subject(CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs.builder()
 *                     .commonName("example.com")
 *                     .build())
 *                 .build())
 *             .permanentDeletionTimeInDays(7)
 *             .build());
 *         var key = new PrivateKey("key", PrivateKeyArgs.builder()
 *             .algorithm("RSA")
 *             .build());
 *         var csr = new CertRequest("csr", CertRequestArgs.builder()
 *             .privateKeyPem(key.privateKeyPem())
 *             .subject(CertRequestSubjectArgs.builder()
 *                 .commonName("example")
 *                 .build())
 *             .build());
 *         var example = new Certificate("example", CertificateArgs.builder()
 *             .certificateAuthorityArn(exampleCertificateAuthority.arn())
 *             .certificateSigningRequest(csr.certRequestPem())
 *             .signingAlgorithm("SHA256WITHRSA")
 *             .validity(CertificateValidityArgs.builder()
 *                 .type("YEARS")
 *                 .value(1)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:acmpca:Certificate
 *     properties:
 *       certificateAuthorityArn: ${exampleCertificateAuthority.arn}
 *       certificateSigningRequest: ${csr.certRequestPem}
 *       signingAlgorithm: SHA256WITHRSA
 *       validity:
 *         type: YEARS
 *         value: 1
 *   exampleCertificateAuthority:
 *     type: aws:acmpca:CertificateAuthority
 *     name: example
 *     properties:
 *       certificateAuthorityConfiguration:
 *         keyAlgorithm: RSA_4096
 *         signingAlgorithm: SHA512WITHRSA
 *         subject:
 *           commonName: example.com
 *       permanentDeletionTimeInDays: 7
 *   key:
 *     type: tls:PrivateKey
 *     properties:
 *       algorithm: RSA
 *   csr:
 *     type: tls:CertRequest
 *     properties:
 *       privateKeyPem: ${key.privateKeyPem}
 *       subject:
 *         commonName: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ACM PCA Certificates using their ARN. For example:
 * ```sh
 * $ pulumi import aws:acmpca/certificate:Certificate cert arn:aws:acm-pca:eu-west-1:675225743824:certificate-authority/08319ede-83g9-1400-8f21-c7d12b2b6edb/certificate/a4e9c2aa4bcfab625g1b9136464cd3a
 * ```
 */
public class Certificate internal constructor(
    override val javaResource: com.pulumi.aws.acmpca.Certificate,
) : KotlinCustomResource(javaResource, CertificateMapper) {
    /**
     * Specifies X.509 certificate information to be included in the issued certificate. To use with API Passthrough templates
     */
    public val apiPassthrough: Output<String>?
        get() = javaResource.apiPassthrough().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the certificate.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * PEM-encoded certificate value.
     */
    public val certificate: Output<String>
        get() = javaResource.certificate().applyValue({ args0 -> args0 })

    /**
     * ARN of the certificate authority.
     */
    public val certificateAuthorityArn: Output<String>
        get() = javaResource.certificateAuthorityArn().applyValue({ args0 -> args0 })

    /**
     * PEM-encoded certificate chain that includes any intermediate certificates and chains up to root CA.
     */
    public val certificateChain: Output<String>
        get() = javaResource.certificateChain().applyValue({ args0 -> args0 })

    /**
     * Certificate Signing Request in PEM format.
     */
    public val certificateSigningRequest: Output<String>
        get() = javaResource.certificateSigningRequest().applyValue({ args0 -> args0 })

    /**
     * Algorithm to use to sign certificate requests. Valid values: `SHA256WITHRSA`, `SHA256WITHECDSA`, `SHA384WITHRSA`, `SHA384WITHECDSA`, `SHA512WITHRSA`, `SHA512WITHECDSA`.
     */
    public val signingAlgorithm: Output<String>
        get() = javaResource.signingAlgorithm().applyValue({ args0 -> args0 })

    /**
     * Template to use when issuing a certificate.
     * See [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html) for more information.
     */
    public val templateArn: Output<String>?
        get() = javaResource.templateArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configures end of the validity period for the certificate. See validity block below.
     */
    public val validity: Output<CertificateValidity>
        get() = javaResource.validity().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
}

public object CertificateMapper : ResourceMapper<Certificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.acmpca.Certificate::class == javaResource::class

    override fun map(javaResource: Resource): Certificate = Certificate(
        javaResource as
            com.pulumi.aws.acmpca.Certificate,
    )
}

/**
 * @see [Certificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Certificate].
 */
public suspend fun certificate(name: String, block: suspend CertificateResourceBuilder.() -> Unit): Certificate {
    val builder = CertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Certificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun certificate(name: String): Certificate {
    val builder = CertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
