@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin.inputs

import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property commonName Fully qualified domain name (FQDN) associated with the certificate subject. Must be less than or equal to 64 characters in length.
 * @property country Two digit code that specifies the country in which the certificate subject located. Must be less than or equal to 2 characters in length.
 * @property distinguishedNameQualifier Disambiguating information for the certificate subject. Must be less than or equal to 64 characters in length.
 * @property generationQualifier Typically a qualifier appended to the name of an individual. Examples include Jr. for junior, Sr. for senior, and III for third. Must be less than or equal to 3 characters in length.
 * @property givenName First name. Must be less than or equal to 16 characters in length.
 * @property initials Concatenation that typically contains the first letter of the `given_name`, the first letter of the middle name if one exists, and the first letter of the `surname`. Must be less than or equal to 5 characters in length.
 * @property locality Locality (such as a city or town) in which the certificate subject is located. Must be less than or equal to 128 characters in length.
 * @property organization Legal name of the organization with which the certificate subject is affiliated. Must be less than or equal to 64 characters in length.
 * @property organizationalUnit Subdivision or unit of the organization (such as sales or finance) with which the certificate subject is affiliated. Must be less than or equal to 64 characters in length.
 * @property pseudonym Typically a shortened version of a longer `given_name`. For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth, Liz, or Eliza. Must be less than or equal to 128 characters in length.
 * @property state State in which the subject of the certificate is located. Must be less than or equal to 128 characters in length.
 * @property surname Family name. In the US and the UK for example, the surname of an individual is ordered last. In Asian cultures the surname is typically ordered first. Must be less than or equal to 40 characters in length.
 * @property title Title such as Mr. or Ms. which is pre-pended to the name to refer formally to the certificate subject. Must be less than or equal to 64 characters in length.
 */
public data class CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs(
    public val commonName: Output<String>? = null,
    public val country: Output<String>? = null,
    public val distinguishedNameQualifier: Output<String>? = null,
    public val generationQualifier: Output<String>? = null,
    public val givenName: Output<String>? = null,
    public val initials: Output<String>? = null,
    public val locality: Output<String>? = null,
    public val organization: Output<String>? = null,
    public val organizationalUnit: Output<String>? = null,
    public val pseudonym: Output<String>? = null,
    public val state: Output<String>? = null,
    public val surname: Output<String>? = null,
    public val title: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs> {
    override fun toJava(): com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs =
        com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs.builder()
            .commonName(commonName?.applyValue({ args0 -> args0 }))
            .country(country?.applyValue({ args0 -> args0 }))
            .distinguishedNameQualifier(distinguishedNameQualifier?.applyValue({ args0 -> args0 }))
            .generationQualifier(generationQualifier?.applyValue({ args0 -> args0 }))
            .givenName(givenName?.applyValue({ args0 -> args0 }))
            .initials(initials?.applyValue({ args0 -> args0 }))
            .locality(locality?.applyValue({ args0 -> args0 }))
            .organization(organization?.applyValue({ args0 -> args0 }))
            .organizationalUnit(organizationalUnit?.applyValue({ args0 -> args0 }))
            .pseudonym(pseudonym?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0 }))
            .surname(surname?.applyValue({ args0 -> args0 }))
            .title(title?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs].
 */
@PulumiTagMarker
public class CertificateAuthorityCertificateAuthorityConfigurationSubjectArgsBuilder internal constructor() {
    private var commonName: Output<String>? = null

    private var country: Output<String>? = null

    private var distinguishedNameQualifier: Output<String>? = null

    private var generationQualifier: Output<String>? = null

    private var givenName: Output<String>? = null

    private var initials: Output<String>? = null

    private var locality: Output<String>? = null

    private var organization: Output<String>? = null

    private var organizationalUnit: Output<String>? = null

    private var pseudonym: Output<String>? = null

    private var state: Output<String>? = null

    private var surname: Output<String>? = null

    private var title: Output<String>? = null

    /**
     * @param value Fully qualified domain name (FQDN) associated with the certificate subject. Must be less than or equal to 64 characters in length.
     */
    @JvmName("djvhvcwaegnrjmqt")
    public suspend fun commonName(`value`: Output<String>) {
        this.commonName = value
    }

    /**
     * @param value Two digit code that specifies the country in which the certificate subject located. Must be less than or equal to 2 characters in length.
     */
    @JvmName("hyamprfemweurhfm")
    public suspend fun country(`value`: Output<String>) {
        this.country = value
    }

    /**
     * @param value Disambiguating information for the certificate subject. Must be less than or equal to 64 characters in length.
     */
    @JvmName("tryqiyktimpvjkhu")
    public suspend fun distinguishedNameQualifier(`value`: Output<String>) {
        this.distinguishedNameQualifier = value
    }

    /**
     * @param value Typically a qualifier appended to the name of an individual. Examples include Jr. for junior, Sr. for senior, and III for third. Must be less than or equal to 3 characters in length.
     */
    @JvmName("ahptqimvriwmveej")
    public suspend fun generationQualifier(`value`: Output<String>) {
        this.generationQualifier = value
    }

    /**
     * @param value First name. Must be less than or equal to 16 characters in length.
     */
    @JvmName("ahkgvngfnhumvrdm")
    public suspend fun givenName(`value`: Output<String>) {
        this.givenName = value
    }

    /**
     * @param value Concatenation that typically contains the first letter of the `given_name`, the first letter of the middle name if one exists, and the first letter of the `surname`. Must be less than or equal to 5 characters in length.
     */
    @JvmName("vrwisoughfovqieh")
    public suspend fun initials(`value`: Output<String>) {
        this.initials = value
    }

    /**
     * @param value Locality (such as a city or town) in which the certificate subject is located. Must be less than or equal to 128 characters in length.
     */
    @JvmName("npilqdpkhqdabhfd")
    public suspend fun locality(`value`: Output<String>) {
        this.locality = value
    }

    /**
     * @param value Legal name of the organization with which the certificate subject is affiliated. Must be less than or equal to 64 characters in length.
     */
    @JvmName("joxyqktwhmgwgqql")
    public suspend fun organization(`value`: Output<String>) {
        this.organization = value
    }

    /**
     * @param value Subdivision or unit of the organization (such as sales or finance) with which the certificate subject is affiliated. Must be less than or equal to 64 characters in length.
     */
    @JvmName("ascbprgjhwiknqhf")
    public suspend fun organizationalUnit(`value`: Output<String>) {
        this.organizationalUnit = value
    }

    /**
     * @param value Typically a shortened version of a longer `given_name`. For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth, Liz, or Eliza. Must be less than or equal to 128 characters in length.
     */
    @JvmName("utdfhenddyrfyyrv")
    public suspend fun pseudonym(`value`: Output<String>) {
        this.pseudonym = value
    }

    /**
     * @param value State in which the subject of the certificate is located. Must be less than or equal to 128 characters in length.
     */
    @JvmName("aggxfwwgpholfppa")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value Family name. In the US and the UK for example, the surname of an individual is ordered last. In Asian cultures the surname is typically ordered first. Must be less than or equal to 40 characters in length.
     */
    @JvmName("faifimvgiwqqdswc")
    public suspend fun surname(`value`: Output<String>) {
        this.surname = value
    }

    /**
     * @param value Title such as Mr. or Ms. which is pre-pended to the name to refer formally to the certificate subject. Must be less than or equal to 64 characters in length.
     */
    @JvmName("jswykqwburooybml")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value Fully qualified domain name (FQDN) associated with the certificate subject. Must be less than or equal to 64 characters in length.
     */
    @JvmName("eftwwqkynkspvtpg")
    public suspend fun commonName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commonName = mapped
    }

    /**
     * @param value Two digit code that specifies the country in which the certificate subject located. Must be less than or equal to 2 characters in length.
     */
    @JvmName("mqocggiefewcweyh")
    public suspend fun country(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.country = mapped
    }

    /**
     * @param value Disambiguating information for the certificate subject. Must be less than or equal to 64 characters in length.
     */
    @JvmName("pocsyokheoypoqop")
    public suspend fun distinguishedNameQualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distinguishedNameQualifier = mapped
    }

    /**
     * @param value Typically a qualifier appended to the name of an individual. Examples include Jr. for junior, Sr. for senior, and III for third. Must be less than or equal to 3 characters in length.
     */
    @JvmName("ugmeyfsodogiolwf")
    public suspend fun generationQualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.generationQualifier = mapped
    }

    /**
     * @param value First name. Must be less than or equal to 16 characters in length.
     */
    @JvmName("ejstnurwpossnfon")
    public suspend fun givenName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.givenName = mapped
    }

    /**
     * @param value Concatenation that typically contains the first letter of the `given_name`, the first letter of the middle name if one exists, and the first letter of the `surname`. Must be less than or equal to 5 characters in length.
     */
    @JvmName("rhukxfpetjibbmmd")
    public suspend fun initials(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initials = mapped
    }

    /**
     * @param value Locality (such as a city or town) in which the certificate subject is located. Must be less than or equal to 128 characters in length.
     */
    @JvmName("yyfqvbfptuywfvtd")
    public suspend fun locality(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locality = mapped
    }

    /**
     * @param value Legal name of the organization with which the certificate subject is affiliated. Must be less than or equal to 64 characters in length.
     */
    @JvmName("oompgewqiskewsbn")
    public suspend fun organization(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organization = mapped
    }

    /**
     * @param value Subdivision or unit of the organization (such as sales or finance) with which the certificate subject is affiliated. Must be less than or equal to 64 characters in length.
     */
    @JvmName("lvlvufeibmgsifpy")
    public suspend fun organizationalUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationalUnit = mapped
    }

    /**
     * @param value Typically a shortened version of a longer `given_name`. For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth, Liz, or Eliza. Must be less than or equal to 128 characters in length.
     */
    @JvmName("cmfhppfpjutowjtf")
    public suspend fun pseudonym(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pseudonym = mapped
    }

    /**
     * @param value State in which the subject of the certificate is located. Must be less than or equal to 128 characters in length.
     */
    @JvmName("fvxrvrvvaswctxcg")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Family name. In the US and the UK for example, the surname of an individual is ordered last. In Asian cultures the surname is typically ordered first. Must be less than or equal to 40 characters in length.
     */
    @JvmName("vtygsocervdheqeg")
    public suspend fun surname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.surname = mapped
    }

    /**
     * @param value Title such as Mr. or Ms. which is pre-pended to the name to refer formally to the certificate subject. Must be less than or equal to 64 characters in length.
     */
    @JvmName("oektgjenkscfjbtk")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    internal fun build(): CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs =
        CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs(
            commonName = commonName,
            country = country,
            distinguishedNameQualifier = distinguishedNameQualifier,
            generationQualifier = generationQualifier,
            givenName = givenName,
            initials = initials,
            locality = locality,
            organization = organization,
            organizationalUnit = organizationalUnit,
            pseudonym = pseudonym,
            state = state,
            surname = surname,
            title = title,
        )
}
