@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin.inputs

import com.pulumi.aws.acmpca.inputs.CertificateAuthorityRevocationConfigurationCrlConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property customCname Name inserted into the certificate CRL Distribution Points extension that enables the use of an alias for the CRL distribution point. Use this value if you don't want the name of your S3 bucket to be public. Must be less than or equal to 253 characters in length.
 * @property enabled Boolean value that specifies whether certificate revocation lists (CRLs) are enabled. Defaults to `false`.
 * @property expirationInDays Number of days until a certificate expires. Must be between 1 and 5000.
 * @property s3BucketName Name of the S3 bucket that contains the CRL. If you do not provide a value for the `custom_cname` argument, the name of your S3 bucket is placed into the CRL Distribution Points extension of the issued certificate. You must specify a bucket policy that allows ACM PCA to write the CRL to your bucket. Must be between 3 and 255 characters in length.
 * @property s3ObjectAcl Determines whether the CRL will be publicly readable or privately held in the CRL Amazon S3 bucket. Defaults to `PUBLIC_READ`.
 */
public data class CertificateAuthorityRevocationConfigurationCrlConfigurationArgs(
    public val customCname: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val expirationInDays: Output<Int>? = null,
    public val s3BucketName: Output<String>? = null,
    public val s3ObjectAcl: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.acmpca.inputs.CertificateAuthorityRevocationConfigurationCrlConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.acmpca.inputs.CertificateAuthorityRevocationConfigurationCrlConfigurationArgs =
        com.pulumi.aws.acmpca.inputs.CertificateAuthorityRevocationConfigurationCrlConfigurationArgs.builder()
            .customCname(customCname?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .expirationInDays(expirationInDays?.applyValue({ args0 -> args0 }))
            .s3BucketName(s3BucketName?.applyValue({ args0 -> args0 }))
            .s3ObjectAcl(s3ObjectAcl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateAuthorityRevocationConfigurationCrlConfigurationArgs].
 */
@PulumiTagMarker
public class CertificateAuthorityRevocationConfigurationCrlConfigurationArgsBuilder internal constructor() {
    private var customCname: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var expirationInDays: Output<Int>? = null

    private var s3BucketName: Output<String>? = null

    private var s3ObjectAcl: Output<String>? = null

    /**
     * @param value Name inserted into the certificate CRL Distribution Points extension that enables the use of an alias for the CRL distribution point. Use this value if you don't want the name of your S3 bucket to be public. Must be less than or equal to 253 characters in length.
     */
    @JvmName("ibyaxliyigalkrmy")
    public suspend fun customCname(`value`: Output<String>) {
        this.customCname = value
    }

    /**
     * @param value Boolean value that specifies whether certificate revocation lists (CRLs) are enabled. Defaults to `false`.
     */
    @JvmName("mbhfqkdianumikgf")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Number of days until a certificate expires. Must be between 1 and 5000.
     */
    @JvmName("porsnjulmhgeygiq")
    public suspend fun expirationInDays(`value`: Output<Int>) {
        this.expirationInDays = value
    }

    /**
     * @param value Name of the S3 bucket that contains the CRL. If you do not provide a value for the `custom_cname` argument, the name of your S3 bucket is placed into the CRL Distribution Points extension of the issued certificate. You must specify a bucket policy that allows ACM PCA to write the CRL to your bucket. Must be between 3 and 255 characters in length.
     */
    @JvmName("fkcssantctsygdan")
    public suspend fun s3BucketName(`value`: Output<String>) {
        this.s3BucketName = value
    }

    /**
     * @param value Determines whether the CRL will be publicly readable or privately held in the CRL Amazon S3 bucket. Defaults to `PUBLIC_READ`.
     */
    @JvmName("mgaalefcdswxnsad")
    public suspend fun s3ObjectAcl(`value`: Output<String>) {
        this.s3ObjectAcl = value
    }

    /**
     * @param value Name inserted into the certificate CRL Distribution Points extension that enables the use of an alias for the CRL distribution point. Use this value if you don't want the name of your S3 bucket to be public. Must be less than or equal to 253 characters in length.
     */
    @JvmName("cjkdgptwxrqehvuf")
    public suspend fun customCname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customCname = mapped
    }

    /**
     * @param value Boolean value that specifies whether certificate revocation lists (CRLs) are enabled. Defaults to `false`.
     */
    @JvmName("miajbsrlymlbeksp")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Number of days until a certificate expires. Must be between 1 and 5000.
     */
    @JvmName("cgvxyluaqojbxgan")
    public suspend fun expirationInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expirationInDays = mapped
    }

    /**
     * @param value Name of the S3 bucket that contains the CRL. If you do not provide a value for the `custom_cname` argument, the name of your S3 bucket is placed into the CRL Distribution Points extension of the issued certificate. You must specify a bucket policy that allows ACM PCA to write the CRL to your bucket. Must be between 3 and 255 characters in length.
     */
    @JvmName("tqfajremnxkxcfbm")
    public suspend fun s3BucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3BucketName = mapped
    }

    /**
     * @param value Determines whether the CRL will be publicly readable or privately held in the CRL Amazon S3 bucket. Defaults to `PUBLIC_READ`.
     */
    @JvmName("ejebrcawmfycbdhl")
    public suspend fun s3ObjectAcl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3ObjectAcl = mapped
    }

    internal fun build(): CertificateAuthorityRevocationConfigurationCrlConfigurationArgs =
        CertificateAuthorityRevocationConfigurationCrlConfigurationArgs(
            customCname = customCname,
            enabled = enabled,
            expirationInDays = expirationInDays,
            s3BucketName = s3BucketName,
            s3ObjectAcl = s3ObjectAcl,
        )
}
