@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin.inputs

import com.pulumi.aws.acmpca.inputs.CertificateAuthorityRevocationConfigurationOcspConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Boolean value that specifies whether a custom OCSP responder is enabled.
 * @property ocspCustomCname CNAME specifying a customized OCSP domain. Note: The value of the CNAME must not include a protocol prefix such as "http://" or "https://".
 */
public data class CertificateAuthorityRevocationConfigurationOcspConfigurationArgs(
    public val enabled: Output<Boolean>,
    public val ocspCustomCname: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.acmpca.inputs.CertificateAuthorityRevocationConfigurationOcspConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.acmpca.inputs.CertificateAuthorityRevocationConfigurationOcspConfigurationArgs =
        com.pulumi.aws.acmpca.inputs.CertificateAuthorityRevocationConfigurationOcspConfigurationArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .ocspCustomCname(ocspCustomCname?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateAuthorityRevocationConfigurationOcspConfigurationArgs].
 */
@PulumiTagMarker
public class CertificateAuthorityRevocationConfigurationOcspConfigurationArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var ocspCustomCname: Output<String>? = null

    /**
     * @param value Boolean value that specifies whether a custom OCSP responder is enabled.
     */
    @JvmName("xkxskbichmucxcvv")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value CNAME specifying a customized OCSP domain. Note: The value of the CNAME must not include a protocol prefix such as "http://" or "https://".
     */
    @JvmName("dlkndnuicnintkpa")
    public suspend fun ocspCustomCname(`value`: Output<String>) {
        this.ocspCustomCname = value
    }

    /**
     * @param value Boolean value that specifies whether a custom OCSP responder is enabled.
     */
    @JvmName("vwmlaguccupvpubq")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value CNAME specifying a customized OCSP domain. Note: The value of the CNAME must not include a protocol prefix such as "http://" or "https://".
     */
    @JvmName("apjthrkrwuktmhjl")
    public suspend fun ocspCustomCname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ocspCustomCname = mapped
    }

    internal fun build(): CertificateAuthorityRevocationConfigurationOcspConfigurationArgs =
        CertificateAuthorityRevocationConfigurationOcspConfigurationArgs(
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
            ocspCustomCname = ocspCustomCname,
        )
}
