@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin.inputs

import com.pulumi.aws.acmpca.inputs.GetCertificateAuthorityPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCertificateAuthority.
 * @property arn ARN of the certificate authority.
 * @property tags Key-value map of user-defined tags that are attached to the certificate authority.
 */
public data class GetCertificateAuthorityPlainArgs(
    public val arn: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.acmpca.inputs.GetCertificateAuthorityPlainArgs> {
    override fun toJava(): com.pulumi.aws.acmpca.inputs.GetCertificateAuthorityPlainArgs =
        com.pulumi.aws.acmpca.inputs.GetCertificateAuthorityPlainArgs.builder()
            .arn(arn.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetCertificateAuthorityPlainArgs].
 */
@PulumiTagMarker
public class GetCertificateAuthorityPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ARN of the certificate authority.
     */
    @JvmName("arhikhvjwhmpbsdy")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Key-value map of user-defined tags that are attached to the certificate authority.
     */
    @JvmName("sylgqwmrfrnidxll")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of user-defined tags that are attached to the certificate authority.
     */
    @JvmName("nwtacryrvhyefwbk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetCertificateAuthorityPlainArgs = GetCertificateAuthorityPlainArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
        tags = tags,
    )
}
