@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin.inputs

import com.pulumi.aws.acmpca.inputs.GetCertificatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCertificate.
 * @property arn ARN of the certificate issued by the private certificate authority.
 * @property certificateAuthorityArn ARN of the certificate authority.
 */
public data class GetCertificatePlainArgs(
    public val arn: String,
    public val certificateAuthorityArn: String,
) : ConvertibleToJava<com.pulumi.aws.acmpca.inputs.GetCertificatePlainArgs> {
    override fun toJava(): com.pulumi.aws.acmpca.inputs.GetCertificatePlainArgs =
        com.pulumi.aws.acmpca.inputs.GetCertificatePlainArgs.builder()
            .arn(arn.let({ args0 -> args0 }))
            .certificateAuthorityArn(certificateAuthorityArn.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCertificatePlainArgs].
 */
@PulumiTagMarker
public class GetCertificatePlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var certificateAuthorityArn: String? = null

    /**
     * @param value ARN of the certificate issued by the private certificate authority.
     */
    @JvmName("ddtuefmsdpkqklre")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value ARN of the certificate authority.
     */
    @JvmName("ocyjoabvvjmgyxrs")
    public suspend fun certificateAuthorityArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.certificateAuthorityArn = mapped
    }

    internal fun build(): GetCertificatePlainArgs = GetCertificatePlainArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
        certificateAuthorityArn = certificateAuthorityArn ?: throw
            PulumiNullFieldException("certificateAuthorityArn"),
    )
}
