@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property keyAlgorithm Type of the public key algorithm and size, in bits, of the key pair that your key pair creates when it issues a certificate. Valid values can be found in the [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthorityConfiguration.html).
 * @property signingAlgorithm Name of the algorithm your private CA uses to sign certificate requests. Valid values can be found in the [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CertificateAuthorityConfiguration.html).
 * @property subject Nested argument that contains X.500 distinguished name information. At least one nested attribute must be specified.
 */
public data class CertificateAuthorityCertificateAuthorityConfiguration(
    public val keyAlgorithm: String,
    public val signingAlgorithm: String,
    public val subject: CertificateAuthorityCertificateAuthorityConfigurationSubject,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.acmpca.outputs.CertificateAuthorityCertificateAuthorityConfiguration): CertificateAuthorityCertificateAuthorityConfiguration =
            CertificateAuthorityCertificateAuthorityConfiguration(
                keyAlgorithm = javaType.keyAlgorithm(),
                signingAlgorithm = javaType.signingAlgorithm(),
                subject = javaType.subject().let({ args0 ->
                    com.pulumi.aws.acmpca.kotlin.outputs.CertificateAuthorityCertificateAuthorityConfigurationSubject.Companion.toKotlin(args0)
                }),
            )
    }
}
