@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property crlConfiguration Nested argument containing configuration of the certificate revocation list (CRL), if any, maintained by the certificate authority. Defined below.
 * @property ocspConfiguration Nested argument containing configuration of
 * the custom OCSP responder endpoint. Defined below.
 */
public data class CertificateAuthorityRevocationConfiguration(
    public val crlConfiguration: CertificateAuthorityRevocationConfigurationCrlConfiguration? = null,
    public val ocspConfiguration: CertificateAuthorityRevocationConfigurationOcspConfiguration? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.acmpca.outputs.CertificateAuthorityRevocationConfiguration): CertificateAuthorityRevocationConfiguration = CertificateAuthorityRevocationConfiguration(
            crlConfiguration = javaType.crlConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.acmpca.kotlin.outputs.CertificateAuthorityRevocationConfigurationCrlConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ocspConfiguration = javaType.ocspConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.acmpca.kotlin.outputs.CertificateAuthorityRevocationConfigurationOcspConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
