@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property customCname Name inserted into the certificate CRL Distribution Points extension that enables the use of an alias for the CRL distribution point. Use this value if you don't want the name of your S3 bucket to be public. Must be less than or equal to 253 characters in length.
 * @property enabled Boolean value that specifies whether certificate revocation lists (CRLs) are enabled. Defaults to `false`.
 * @property expirationInDays Number of days until a certificate expires. Must be between 1 and 5000.
 * @property s3BucketName Name of the S3 bucket that contains the CRL. If you do not provide a value for the `custom_cname` argument, the name of your S3 bucket is placed into the CRL Distribution Points extension of the issued certificate. You must specify a bucket policy that allows ACM PCA to write the CRL to your bucket. Must be between 3 and 255 characters in length.
 * @property s3ObjectAcl Determines whether the CRL will be publicly readable or privately held in the CRL Amazon S3 bucket. Defaults to `PUBLIC_READ`.
 */
public data class CertificateAuthorityRevocationConfigurationCrlConfiguration(
    public val customCname: String? = null,
    public val enabled: Boolean? = null,
    public val expirationInDays: Int? = null,
    public val s3BucketName: String? = null,
    public val s3ObjectAcl: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.acmpca.outputs.CertificateAuthorityRevocationConfigurationCrlConfiguration): CertificateAuthorityRevocationConfigurationCrlConfiguration =
            CertificateAuthorityRevocationConfigurationCrlConfiguration(
                customCname = javaType.customCname().map({ args0 -> args0 }).orElse(null),
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
                expirationInDays = javaType.expirationInDays().map({ args0 -> args0 }).orElse(null),
                s3BucketName = javaType.s3BucketName().map({ args0 -> args0 }).orElse(null),
                s3ObjectAcl = javaType.s3ObjectAcl().map({ args0 -> args0 }).orElse(null),
            )
    }
}
