@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Boolean value that specifies whether a custom OCSP responder is enabled.
 * @property ocspCustomCname CNAME specifying a customized OCSP domain. Note: The value of the CNAME must not include a protocol prefix such as "http://" or "https://".
 */
public data class CertificateAuthorityRevocationConfigurationOcspConfiguration(
    public val enabled: Boolean,
    public val ocspCustomCname: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.acmpca.outputs.CertificateAuthorityRevocationConfigurationOcspConfiguration): CertificateAuthorityRevocationConfigurationOcspConfiguration =
            CertificateAuthorityRevocationConfigurationOcspConfiguration(
                enabled = javaType.enabled(),
                ocspCustomCname = javaType.ocspCustomCname().map({ args0 -> args0 }).orElse(null),
            )
    }
}
