@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property crlConfigurations Nested attribute containing configuration of the certificate revocation list (CRL), if any, maintained by the certificate authority.
 * @property ocspConfigurations
 */
public data class GetCertificateAuthorityRevocationConfiguration(
    public val crlConfigurations: List<GetCertificateAuthorityRevocationConfigurationCrlConfiguration>,
    public val ocspConfigurations: List<GetCertificateAuthorityRevocationConfigurationOcspConfiguration>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.acmpca.outputs.GetCertificateAuthorityRevocationConfiguration): GetCertificateAuthorityRevocationConfiguration =
            GetCertificateAuthorityRevocationConfiguration(
                crlConfigurations = javaType.crlConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.acmpca.kotlin.outputs.GetCertificateAuthorityRevocationConfigurationCrlConfiguration.Companion.toKotlin(args0)
                    })
                }),
                ocspConfigurations = javaType.ocspConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.acmpca.kotlin.outputs.GetCertificateAuthorityRevocationConfigurationOcspConfiguration.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
