@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property customCname Name inserted into the certificate CRL Distribution Points extension that enables the use of an alias for the CRL distribution point.
 * @property enabled Boolean value that specifies whether certificate revocation lists (CRLs) are enabled.
 * @property expirationInDays Number of days until a certificate expires.
 * @property s3BucketName Name of the S3 bucket that contains the CRL.
 * @property s3ObjectAcl Whether the CRL is publicly readable or privately held in the CRL Amazon S3 bucket.
 */
public data class GetCertificateAuthorityRevocationConfigurationCrlConfiguration(
    public val customCname: String,
    public val enabled: Boolean,
    public val expirationInDays: Int,
    public val s3BucketName: String,
    public val s3ObjectAcl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.acmpca.outputs.GetCertificateAuthorityRevocationConfigurationCrlConfiguration): GetCertificateAuthorityRevocationConfigurationCrlConfiguration =
            GetCertificateAuthorityRevocationConfigurationCrlConfiguration(
                customCname = javaType.customCname(),
                enabled = javaType.enabled(),
                expirationInDays = javaType.expirationInDays(),
                s3BucketName = javaType.s3BucketName(),
                s3ObjectAcl = javaType.s3ObjectAcl(),
            )
    }
}
