@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Boolean value that specifies whether a custom OCSP responder is enabled.
 * @property ocspCustomCname A CNAME specifying a customized OCSP domain.
 */
public data class GetCertificateAuthorityRevocationConfigurationOcspConfiguration(
    public val enabled: Boolean,
    public val ocspCustomCname: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.acmpca.outputs.GetCertificateAuthorityRevocationConfigurationOcspConfiguration): GetCertificateAuthorityRevocationConfigurationOcspConfiguration =
            GetCertificateAuthorityRevocationConfigurationOcspConfiguration(
                enabled = javaType.enabled(),
                ocspCustomCname = javaType.ocspCustomCname(),
            )
    }
}
