@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.acmpca.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getCertificate.
 * @property arn
 * @property certificate PEM-encoded certificate value.
 * @property certificateAuthorityArn
 * @property certificateChain PEM-encoded certificate chain that includes any intermediate certificates and chains up to root CA.
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetCertificateResult(
    public val arn: String,
    public val certificate: String,
    public val certificateAuthorityArn: String,
    public val certificateChain: String,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.acmpca.outputs.GetCertificateResult): GetCertificateResult = GetCertificateResult(
            arn = javaType.arn(),
            certificate = javaType.certificate(),
            certificateAuthorityArn = javaType.certificateAuthorityArn(),
            certificateChain = javaType.certificateChain(),
            id = javaType.id(),
        )
    }
}
