@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin

import com.pulumi.aws.alb.AlbFunctions.getListenerPlain
import com.pulumi.aws.alb.AlbFunctions.getLoadBalancerPlain
import com.pulumi.aws.alb.AlbFunctions.getTargetGroupPlain
import com.pulumi.aws.alb.kotlin.inputs.GetListenerPlainArgs
import com.pulumi.aws.alb.kotlin.inputs.GetListenerPlainArgsBuilder
import com.pulumi.aws.alb.kotlin.inputs.GetLoadBalancerPlainArgs
import com.pulumi.aws.alb.kotlin.inputs.GetLoadBalancerPlainArgsBuilder
import com.pulumi.aws.alb.kotlin.inputs.GetTargetGroupPlainArgs
import com.pulumi.aws.alb.kotlin.inputs.GetTargetGroupPlainArgsBuilder
import com.pulumi.aws.alb.kotlin.outputs.GetListenerResult
import com.pulumi.aws.alb.kotlin.outputs.GetLoadBalancerResult
import com.pulumi.aws.alb.kotlin.outputs.GetTargetGroupResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.alb.kotlin.outputs.GetListenerResult.Companion.toKotlin as getListenerResultToKotlin
import com.pulumi.aws.alb.kotlin.outputs.GetLoadBalancerResult.Companion.toKotlin as getLoadBalancerResultToKotlin
import com.pulumi.aws.alb.kotlin.outputs.GetTargetGroupResult.Companion.toKotlin as getTargetGroupResultToKotlin

public object AlbFunctions {
    /**
     * > **Note:** `aws.alb.Listener` is known as `aws.lb.Listener`. The functionality is identical.
     * Provides information about a Load Balancer Listener.
     * This data source can prove useful when a module accepts an LB Listener as an input variable and needs to know the LB it is attached to, or other information specific to the listener in question.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const config = new pulumi.Config();
     * const listenerArn = config.require("listenerArn");
     * const listener = aws.lb.getListener({
     *     arn: listenerArn,
     * });
     * // get listener from load_balancer_arn and port
     * const selected = aws.lb.getLoadBalancer({
     *     name: "default-public",
     * });
     * const selected443 = selected.then(selected => aws.lb.getListener({
     *     loadBalancerArn: selected.arn,
     *     port: 443,
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * config = pulumi.Config()
     * listener_arn = config.require("listenerArn")
     * listener = aws.lb.get_listener(arn=listener_arn)
     * # get listener from load_balancer_arn and port
     * selected = aws.lb.get_load_balancer(name="default-public")
     * selected443 = aws.lb.get_listener(load_balancer_arn=selected.arn,
     *     port=443)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var listenerArn = config.Require("listenerArn");
     *     var listener = Aws.LB.GetListener.Invoke(new()
     *     {
     *         Arn = listenerArn,
     *     });
     *     // get listener from load_balancer_arn and port
     *     var selected = Aws.LB.GetLoadBalancer.Invoke(new()
     *     {
     *         Name = "default-public",
     *     });
     *     var selected443 = Aws.LB.GetListener.Invoke(new()
     *     {
     *         LoadBalancerArn = selected.Apply(getLoadBalancerResult => getLoadBalancerResult.Arn),
     *         Port = 443,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		listenerArn := cfg.Require("listenerArn")
     * 		_, err := lb.LookupListener(ctx, &lb.LookupListenerArgs{
     * 			Arn: pulumi.StringRef(listenerArn),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// get listener from load_balancer_arn and port
     * 		selected, err := lb.LookupLoadBalancer(ctx, &lb.LookupLoadBalancerArgs{
     * 			Name: pulumi.StringRef("default-public"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = lb.LookupListener(ctx, &lb.LookupListenerArgs{
     * 			LoadBalancerArn: pulumi.StringRef(selected.Arn),
     * 			Port:            pulumi.IntRef(443),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetListenerArgs;
     * import com.pulumi.aws.lb.inputs.GetLoadBalancerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var listenerArn = config.get("listenerArn");
     *         final var listener = LbFunctions.getListener(GetListenerArgs.builder()
     *             .arn(listenerArn)
     *             .build());
     *         // get listener from load_balancer_arn and port
     *         final var selected = LbFunctions.getLoadBalancer(GetLoadBalancerArgs.builder()
     *             .name("default-public")
     *             .build());
     *         final var selected443 = LbFunctions.getListener(GetListenerArgs.builder()
     *             .loadBalancerArn(selected.applyValue(getLoadBalancerResult -> getLoadBalancerResult.arn()))
     *             .port(443)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   # get listener from listener arn
     *   listenerArn:
     *     type: string
     * variables:
     *   listener:
     *     fn::invoke:
     *       Function: aws:lb:getListener
     *       Arguments:
     *         arn: ${listenerArn}
     *   # get listener from load_balancer_arn and port
     *   selected:
     *     fn::invoke:
     *       Function: aws:lb:getLoadBalancer
     *       Arguments:
     *         name: default-public
     *   selected443:
     *     fn::invoke:
     *       Function: aws:lb:getListener
     *       Arguments:
     *         loadBalancerArn: ${selected.arn}
     *         port: 443
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getListener.
     * @return A collection of values returned by getListener.
     */
    public suspend fun getListener(argument: GetListenerPlainArgs): GetListenerResult =
        getListenerResultToKotlin(getListenerPlain(argument.toJava()).await())

    /**
     * @see [getListener].
     * @param arn ARN of the listener. Required if `load_balancer_arn` and `port` is not set.
     * @param loadBalancerArn ARN of the load balancer. Required if `arn` is not set.
     * @param port Port of the listener. Required if `arn` is not set.
     * @param tags
     * @return A collection of values returned by getListener.
     */
    public suspend fun getListener(
        arn: String? = null,
        loadBalancerArn: String? = null,
        port: Int? = null,
        tags: Map<String, String>? = null,
    ): GetListenerResult {
        val argument = GetListenerPlainArgs(
            arn = arn,
            loadBalancerArn = loadBalancerArn,
            port = port,
            tags = tags,
        )
        return getListenerResultToKotlin(getListenerPlain(argument.toJava()).await())
    }

    /**
     * @see [getListener].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;alb&#46;kotlin&#46;inputs&#46;GetListenerPlainArgs].
     * @return A collection of values returned by getListener.
     */
    public suspend fun getListener(argument: suspend GetListenerPlainArgsBuilder.() -> Unit): GetListenerResult {
        val builder = GetListenerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getListenerResultToKotlin(getListenerPlain(builtArgument.toJava()).await())
    }

    /**
     * > **Note:** `aws.alb.LoadBalancer` is known as `aws.lb.LoadBalancer`. The functionality is identical.
     * Provides information about a Load Balancer.
     * This data source can prove useful when a module accepts an LB as an input
     * variable and needs to, for example, determine the security groups associated
     * with it, etc.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const config = new pulumi.Config();
     * const lbArn = config.get("lbArn") || "";
     * const lbName = config.get("lbName") || "";
     * const test = aws.lb.getLoadBalancer({
     *     arn: lbArn,
     *     name: lbName,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * config = pulumi.Config()
     * lb_arn = config.get("lbArn")
     * if lb_arn is None:
     *     lb_arn = ""
     * lb_name = config.get("lbName")
     * if lb_name is None:
     *     lb_name = ""
     * test = aws.lb.get_load_balancer(arn=lb_arn,
     *     name=lb_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var lbArn = config.Get("lbArn") ?? "";
     *     var lbName = config.Get("lbName") ?? "";
     *     var test = Aws.LB.GetLoadBalancer.Invoke(new()
     *     {
     *         Arn = lbArn,
     *         Name = lbName,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		lbArn := ""
     * 		if param := cfg.Get("lbArn"); param != "" {
     * 			lbArn = param
     * 		}
     * 		lbName := ""
     * 		if param := cfg.Get("lbName"); param != "" {
     * 			lbName = param
     * 		}
     * 		_, err := lb.LookupLoadBalancer(ctx, &lb.LookupLoadBalancerArgs{
     * 			Arn:  pulumi.StringRef(lbArn),
     * 			Name: pulumi.StringRef(lbName),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetLoadBalancerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var lbArn = config.get("lbArn").orElse("");
     *         final var lbName = config.get("lbName").orElse("");
     *         final var test = LbFunctions.getLoadBalancer(GetLoadBalancerArgs.builder()
     *             .arn(lbArn)
     *             .name(lbName)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   lbArn:
     *     type: string
     *     default:
     *   lbName:
     *     type: string
     *     default:
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:lb:getLoadBalancer
     *       Arguments:
     *         arn: ${lbArn}
     *         name: ${lbName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLoadBalancer.
     * @return A collection of values returned by getLoadBalancer.
     */
    public suspend fun getLoadBalancer(argument: GetLoadBalancerPlainArgs): GetLoadBalancerResult =
        getLoadBalancerResultToKotlin(getLoadBalancerPlain(argument.toJava()).await())

    /**
     * @see [getLoadBalancer].
     * @param arn Full ARN of the load balancer.
     * @param name Unique name of the load balancer.
     * @param tags Mapping of tags, each pair of which must exactly match a pair on the desired load balancer.
     * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence. `tags` has lowest precedence.
     * @return A collection of values returned by getLoadBalancer.
     */
    public suspend fun getLoadBalancer(
        arn: String? = null,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetLoadBalancerResult {
        val argument = GetLoadBalancerPlainArgs(
            arn = arn,
            name = name,
            tags = tags,
        )
        return getLoadBalancerResultToKotlin(getLoadBalancerPlain(argument.toJava()).await())
    }

    /**
     * @see [getLoadBalancer].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;alb&#46;kotlin&#46;inputs&#46;GetLoadBalancerPlainArgs].
     * @return A collection of values returned by getLoadBalancer.
     */
    public suspend fun getLoadBalancer(argument: suspend GetLoadBalancerPlainArgsBuilder.() -> Unit): GetLoadBalancerResult {
        val builder = GetLoadBalancerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLoadBalancerResultToKotlin(getLoadBalancerPlain(builtArgument.toJava()).await())
    }

    /**
     * > **Note:** `aws.alb.TargetGroup` is known as `aws.lb.TargetGroup`. The functionality is identical.
     * Provides information about a Load Balancer Target Group.
     * This data source can prove useful when a module accepts an LB Target Group as an
     * input variable and needs to know its attributes. It can also be used to get the ARN of
     * an LB Target Group for use in other resources, given LB Target Group name.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const config = new pulumi.Config();
     * const lbTgArn = config.get("lbTgArn") || "";
     * const lbTgName = config.get("lbTgName") || "";
     * const test = aws.lb.getTargetGroup({
     *     arn: lbTgArn,
     *     name: lbTgName,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * config = pulumi.Config()
     * lb_tg_arn = config.get("lbTgArn")
     * if lb_tg_arn is None:
     *     lb_tg_arn = ""
     * lb_tg_name = config.get("lbTgName")
     * if lb_tg_name is None:
     *     lb_tg_name = ""
     * test = aws.lb.get_target_group(arn=lb_tg_arn,
     *     name=lb_tg_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var lbTgArn = config.Get("lbTgArn") ?? "";
     *     var lbTgName = config.Get("lbTgName") ?? "";
     *     var test = Aws.LB.GetTargetGroup.Invoke(new()
     *     {
     *         Arn = lbTgArn,
     *         Name = lbTgName,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		lbTgArn := ""
     * 		if param := cfg.Get("lbTgArn"); param != "" {
     * 			lbTgArn = param
     * 		}
     * 		lbTgName := ""
     * 		if param := cfg.Get("lbTgName"); param != "" {
     * 			lbTgName = param
     * 		}
     * 		_, err := lb.LookupTargetGroup(ctx, &lb.LookupTargetGroupArgs{
     * 			Arn:  pulumi.StringRef(lbTgArn),
     * 			Name: pulumi.StringRef(lbTgName),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lb.LbFunctions;
     * import com.pulumi.aws.lb.inputs.GetTargetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var lbTgArn = config.get("lbTgArn").orElse("");
     *         final var lbTgName = config.get("lbTgName").orElse("");
     *         final var test = LbFunctions.getTargetGroup(GetTargetGroupArgs.builder()
     *             .arn(lbTgArn)
     *             .name(lbTgName)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   lbTgArn:
     *     type: string
     *     default:
     *   lbTgName:
     *     type: string
     *     default:
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:lb:getTargetGroup
     *       Arguments:
     *         arn: ${lbTgArn}
     *         name: ${lbTgName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTargetGroup.
     * @return A collection of values returned by getTargetGroup.
     */
    public suspend fun getTargetGroup(argument: GetTargetGroupPlainArgs): GetTargetGroupResult =
        getTargetGroupResultToKotlin(getTargetGroupPlain(argument.toJava()).await())

    /**
     * @see [getTargetGroup].
     * @param arn Full ARN of the target group.
     * @param loadBalancingAnomalyMitigation
     * @param name Unique name of the target group.
     * @param tags Mapping of tags, each pair of which must exactly match a pair on the desired target group.
     * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence. `tags` has the lowest precedence.
     * @return A collection of values returned by getTargetGroup.
     */
    public suspend fun getTargetGroup(
        arn: String? = null,
        loadBalancingAnomalyMitigation: String? = null,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetTargetGroupResult {
        val argument = GetTargetGroupPlainArgs(
            arn = arn,
            loadBalancingAnomalyMitigation = loadBalancingAnomalyMitigation,
            name = name,
            tags = tags,
        )
        return getTargetGroupResultToKotlin(getTargetGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getTargetGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;alb&#46;kotlin&#46;inputs&#46;GetTargetGroupPlainArgs].
     * @return A collection of values returned by getTargetGroup.
     */
    public suspend fun getTargetGroup(argument: suspend GetTargetGroupPlainArgsBuilder.() -> Unit): GetTargetGroupResult {
        val builder = GetTargetGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTargetGroupResultToKotlin(getTargetGroupPlain(builtArgument.toJava()).await())
    }
}
