@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin

import com.pulumi.aws.alb.TargetGroupAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides the ability to register instances and containers with an Application Load Balancer (ALB) or Network Load Balancer (NLB) target group. For attaching resources with Elastic Load Balancer (ELB), see the `aws.elb.Attachment` resource.
 * > **Note:** `aws.alb.TargetGroupAttachment` is known as `aws.lb.TargetGroupAttachment`. The functionality is identical.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testTargetGroup = new aws.lb.TargetGroup("test", {});
 * const testInstance = new aws.ec2.Instance("test", {});
 * const test = new aws.lb.TargetGroupAttachment("test", {
 *     targetGroupArn: testTargetGroup.arn,
 *     targetId: testInstance.id,
 *     port: 80,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_target_group = aws.lb.TargetGroup("test")
 * test_instance = aws.ec2.Instance("test")
 * test = aws.lb.TargetGroupAttachment("test",
 *     target_group_arn=test_target_group.arn,
 *     target_id=test_instance.id,
 *     port=80)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testTargetGroup = new Aws.LB.TargetGroup("test");
 *     var testInstance = new Aws.Ec2.Instance("test");
 *     var test = new Aws.LB.TargetGroupAttachment("test", new()
 *     {
 *         TargetGroupArn = testTargetGroup.Arn,
 *         TargetId = testInstance.Id,
 *         Port = 80,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		testTargetGroup, err := lb.NewTargetGroup(ctx, "test", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testInstance, err := ec2.NewInstance(ctx, "test", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lb.NewTargetGroupAttachment(ctx, "test", &lb.TargetGroupAttachmentArgs{
 * 			TargetGroupArn: testTargetGroup.Arn,
 * 			TargetId:       testInstance.ID(),
 * 			Port:           pulumi.Int(80),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.TargetGroup;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.lb.TargetGroupAttachment;
 * import com.pulumi.aws.lb.TargetGroupAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testTargetGroup = new TargetGroup("testTargetGroup");
 *         var testInstance = new Instance("testInstance");
 *         var test = new TargetGroupAttachment("test", TargetGroupAttachmentArgs.builder()
 *             .targetGroupArn(testTargetGroup.arn())
 *             .targetId(testInstance.id())
 *             .port(80)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lb:TargetGroupAttachment
 *     properties:
 *       targetGroupArn: ${testTargetGroup.arn}
 *       targetId: ${testInstance.id}
 *       port: 80
 *   testTargetGroup:
 *     type: aws:lb:TargetGroup
 *     name: test
 *   testInstance:
 *     type: aws:ec2:Instance
 *     name: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Lambda Target
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.lb.TargetGroup("test", {
 *     name: "test",
 *     targetType: "lambda",
 * });
 * const testFunction = new aws.lambda.Function("test", {});
 * const withLb = new aws.lambda.Permission("with_lb", {
 *     statementId: "AllowExecutionFromlb",
 *     action: "lambda:InvokeFunction",
 *     "function": testFunction.name,
 *     principal: "elasticloadbalancing.amazonaws.com",
 *     sourceArn: test.arn,
 * });
 * const testTargetGroupAttachment = new aws.lb.TargetGroupAttachment("test", {
 *     targetGroupArn: test.arn,
 *     targetId: testFunction.arn,
 * }, {
 *     dependsOn: [withLb],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.lb.TargetGroup("test",
 *     name="test",
 *     target_type="lambda")
 * test_function = aws.lambda_.Function("test")
 * with_lb = aws.lambda_.Permission("with_lb",
 *     statement_id="AllowExecutionFromlb",
 *     action="lambda:InvokeFunction",
 *     function=test_function.name,
 *     principal="elasticloadbalancing.amazonaws.com",
 *     source_arn=test.arn)
 * test_target_group_attachment = aws.lb.TargetGroupAttachment("test",
 *     target_group_arn=test.arn,
 *     target_id=test_function.arn,
 *     opts = pulumi.ResourceOptions(depends_on=[with_lb]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.LB.TargetGroup("test", new()
 *     {
 *         Name = "test",
 *         TargetType = "lambda",
 *     });
 *     var testFunction = new Aws.Lambda.Function("test");
 *     var withLb = new Aws.Lambda.Permission("with_lb", new()
 *     {
 *         StatementId = "AllowExecutionFromlb",
 *         Action = "lambda:InvokeFunction",
 *         Function = testFunction.Name,
 *         Principal = "elasticloadbalancing.amazonaws.com",
 *         SourceArn = test.Arn,
 *     });
 *     var testTargetGroupAttachment = new Aws.LB.TargetGroupAttachment("test", new()
 *     {
 *         TargetGroupArn = test.Arn,
 *         TargetId = testFunction.Arn,
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             withLb,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := lb.NewTargetGroup(ctx, "test", &lb.TargetGroupArgs{
 * 			Name:       pulumi.String("test"),
 * 			TargetType: pulumi.String("lambda"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testFunction, err := lambda.NewFunction(ctx, "test", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		withLb, err := lambda.NewPermission(ctx, "with_lb", &lambda.PermissionArgs{
 * 			StatementId: pulumi.String("AllowExecutionFromlb"),
 * 			Action:      pulumi.String("lambda:InvokeFunction"),
 * 			Function:    testFunction.Name,
 * 			Principal:   pulumi.String("elasticloadbalancing.amazonaws.com"),
 * 			SourceArn:   test.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lb.NewTargetGroupAttachment(ctx, "test", &lb.TargetGroupAttachmentArgs{
 * 			TargetGroupArn: test.Arn,
 * 			TargetId:       testFunction.Arn,
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			withLb,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.TargetGroup;
 * import com.pulumi.aws.lb.TargetGroupArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.Permission;
 * import com.pulumi.aws.lambda.PermissionArgs;
 * import com.pulumi.aws.lb.TargetGroupAttachment;
 * import com.pulumi.aws.lb.TargetGroupAttachmentArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new TargetGroup("test", TargetGroupArgs.builder()
 *             .name("test")
 *             .targetType("lambda")
 *             .build());
 *         var testFunction = new Function("testFunction");
 *         var withLb = new Permission("withLb", PermissionArgs.builder()
 *             .statementId("AllowExecutionFromlb")
 *             .action("lambda:InvokeFunction")
 *             .function(testFunction.name())
 *             .principal("elasticloadbalancing.amazonaws.com")
 *             .sourceArn(test.arn())
 *             .build());
 *         var testTargetGroupAttachment = new TargetGroupAttachment("testTargetGroupAttachment", TargetGroupAttachmentArgs.builder()
 *             .targetGroupArn(test.arn())
 *             .targetId(testFunction.arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(withLb)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   withLb:
 *     type: aws:lambda:Permission
 *     name: with_lb
 *     properties:
 *       statementId: AllowExecutionFromlb
 *       action: lambda:InvokeFunction
 *       function: ${testFunction.name}
 *       principal: elasticloadbalancing.amazonaws.com
 *       sourceArn: ${test.arn}
 *   test:
 *     type: aws:lb:TargetGroup
 *     properties:
 *       name: test
 *       targetType: lambda
 *   testFunction:
 *     type: aws:lambda:Function
 *     name: test
 *   testTargetGroupAttachment:
 *     type: aws:lb:TargetGroupAttachment
 *     name: test
 *     properties:
 *       targetGroupArn: ${test.arn}
 *       targetId: ${testFunction.arn}
 *     options:
 *       dependson:
 *         - ${withLb}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Registering Multiple Targets
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example: aws.ec2.Instance[] = [];
 * for (const range = {value: 0}; range.value < 3; range.value++) {
 *     example.push(new aws.ec2.Instance(`example-${range.value}`, {}));
 * }
 * const exampleTargetGroup = new aws.lb.TargetGroup("example", {});
 * const exampleTargetGroupAttachment: aws.lb.TargetGroupAttachment[] = [];
 * pulumi.all(example.map((v, k) => [k, v])&#46;reduce((__obj, [, ]) => ({ &#46;&#46;&#46;__obj, [k]: v }))).apply(rangeBody => {
 *     for (const range of Object.entries(rangeBody).map(([k, v]) => ({key: k, value: v}))) {
 *         exampleTargetGroupAttachment.push(new aws.lb.TargetGroupAttachment(`example-${range.key}`, {
 *             targetGroupArn: exampleTargetGroup.arn,
 *             targetId: range.value.id,
 *             port: 80,
 *         }));
 *     }
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = []
 * for range in [{"value": i} for i in range(0, 3)]:
 *     example.append(aws.ec2.Instance(f"example-{range['value']}"))
 * example_target_group = aws.lb.TargetGroup("example")
 * example_target_group_attachment = []
 * def create_example(range_body):
 *     for range in [{"key": k, "value": v} for [k, v] in enumerate(range_body)]:
 *         example_target_group_attachment.append(aws.lb.TargetGroupAttachment(f"example-{range['key']}",
 *             target_group_arn=example_target_group.arn,
 *             target_id=range["value"],
 *             port=80))
 * pulumi.Output.all({k: v for k, v in example}).apply(lambda resolved_outputs: create_example(resolved_outputs[0]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new List<Aws.Ec2.Instance>();
 *     for (var rangeIndex = 0; rangeIndex < 3; rangeIndex++)
 *     {
 *         var range = new { Value = rangeIndex };
 *         example.Add(new Aws.Ec2.Instance($"example-{range.Value}", new()
 *         {
 *         }));
 *     }
 *     var exampleTargetGroup = new Aws.LB.TargetGroup("example");
 *     var exampleTargetGroupAttachment = new List<Aws.LB.TargetGroupAttachment>();
 *     foreach (var range in example.Select((value, i) => new { Key = i.ToString(), Value = pair.Value }).Select(pair => new { pair.Key, pair.Value }))
 *     {
 *         exampleTargetGroupAttachment.Add(new Aws.LB.TargetGroupAttachment($"example-{range.Key}", new()
 *         {
 *             TargetGroupArn = exampleTargetGroup.Arn,
 *             TargetId = range.Value.Id,
 *             Port = 80,
 *         }));
 *     }
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * var example []*ec2.Instance
 * for index := 0; index < 3; index++ {
 *     key0 := index
 *     _ := index
 * __res, err := ec2.NewInstance(ctx, fmt.Sprintf("example-%v", key0), nil)
 * if err != nil {
 * return err
 * }
 * example = append(example, __res)
 * }
 * exampleTargetGroup, err := lb.NewTargetGroup(ctx, "example", nil)
 * if err != nil {
 * return err
 * }
 * var exampleTargetGroupAttachment []*lb.TargetGroupAttachment
 * for key0, val0 := range %!v(PANIC=Format method: fatal: An assertion has failed: tok: ) {
 * __res, err := lb.NewTargetGroupAttachment(ctx, fmt.Sprintf("example-%v", key0), &lb.TargetGroupAttachmentArgs{
 * TargetGroupArn: exampleTargetGroup.Arn,
 * TargetId: pulumi.String(val0),
 * Port: pulumi.Int(80),
 * })
 * if err != nil {
 * return err
 * }
 * exampleTargetGroupAttachment = append(exampleTargetGroupAttachment, __res)
 * }
 * return nil
 * })
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:Instance
 *     options: {}
 *   exampleTargetGroup:
 *     type: aws:lb:TargetGroup
 *     name: example
 *   exampleTargetGroupAttachment:
 *     type: aws:lb:TargetGroupAttachment
 *     name: example
 *     properties:
 *       targetGroupArn: ${exampleTargetGroup.arn}
 *       targetId: ${range.value.id}
 *       port: 80
 *     options: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You cannot import Target Group Attachments.
 * @property availabilityZone The Availability Zone where the IP address of the target is to be registered. If the private IP address is outside of the VPC scope, this value must be set to `all`.
 * @property port The port on which targets receive traffic.
 * @property targetGroupArn The ARN of the target group with which to register targets.
 * @property targetId The ID of the target. This is the Instance ID for an instance, or the container ID for an ECS container. If the target type is `ip`, specify an IP address. If the target type is `lambda`, specify the Lambda function ARN. If the target type is `alb`, specify the ALB ARN.
 * The following arguments are optional:
 */
public data class TargetGroupAttachmentArgs(
    public val availabilityZone: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val targetGroupArn: Output<String>? = null,
    public val targetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.alb.TargetGroupAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.alb.TargetGroupAttachmentArgs =
        com.pulumi.aws.alb.TargetGroupAttachmentArgs.builder()
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .targetGroupArn(targetGroupArn?.applyValue({ args0 -> args0 }))
            .targetId(targetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TargetGroupAttachmentArgs].
 */
@PulumiTagMarker
public class TargetGroupAttachmentArgsBuilder internal constructor() {
    private var availabilityZone: Output<String>? = null

    private var port: Output<Int>? = null

    private var targetGroupArn: Output<String>? = null

    private var targetId: Output<String>? = null

    /**
     * @param value The Availability Zone where the IP address of the target is to be registered. If the private IP address is outside of the VPC scope, this value must be set to `all`.
     */
    @JvmName("xsqsjalqnshwnucy")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value The port on which targets receive traffic.
     */
    @JvmName("jixenhjlyvxtwddb")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The ARN of the target group with which to register targets.
     */
    @JvmName("ejmnnayjouyaswxj")
    public suspend fun targetGroupArn(`value`: Output<String>) {
        this.targetGroupArn = value
    }

    /**
     * @param value The ID of the target. This is the Instance ID for an instance, or the container ID for an ECS container. If the target type is `ip`, specify an IP address. If the target type is `lambda`, specify the Lambda function ARN. If the target type is `alb`, specify the ALB ARN.
     * The following arguments are optional:
     */
    @JvmName("ysaaaqpqgmpkirna")
    public suspend fun targetId(`value`: Output<String>) {
        this.targetId = value
    }

    /**
     * @param value The Availability Zone where the IP address of the target is to be registered. If the private IP address is outside of the VPC scope, this value must be set to `all`.
     */
    @JvmName("dtirbahyovvaiiox")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value The port on which targets receive traffic.
     */
    @JvmName("ibfoikfabrbhcrtd")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The ARN of the target group with which to register targets.
     */
    @JvmName("wjynxwkmvnjctyvw")
    public suspend fun targetGroupArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetGroupArn = mapped
    }

    /**
     * @param value The ID of the target. This is the Instance ID for an instance, or the container ID for an ECS container. If the target type is `ip`, specify an IP address. If the target type is `lambda`, specify the Lambda function ARN. If the target type is `alb`, specify the ALB ARN.
     * The following arguments are optional:
     */
    @JvmName("wudivjoqsrgpsihw")
    public suspend fun targetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetId = mapped
    }

    internal fun build(): TargetGroupAttachmentArgs = TargetGroupAttachmentArgs(
        availabilityZone = availabilityZone,
        port = port,
        targetGroupArn = targetGroupArn,
        targetId = targetId,
    )
}
