@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.inputs

import com.pulumi.aws.alb.inputs.ListenerDefaultActionAuthenticateCognitoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property authenticationRequestExtraParams Query parameters to include in the redirect request to the authorization endpoint. Max: 10. Detailed below.
 * @property onUnauthenticatedRequest Behavior if the user is not authenticated. Valid values are `deny`, `allow` and `authenticate`.
 * @property scope Set of user claims to be requested from the IdP.
 * @property sessionCookieName Name of the cookie used to maintain session information.
 * @property sessionTimeout Maximum duration of the authentication session, in seconds.
 * @property userPoolArn ARN of the Cognito user pool.
 * @property userPoolClientId ID of the Cognito user pool client.
 * @property userPoolDomain Domain prefix or fully-qualified domain name of the Cognito user pool.
 * The following arguments are optional:
 */
public data class ListenerDefaultActionAuthenticateCognitoArgs(
    public val authenticationRequestExtraParams: Output<Map<String, String>>? = null,
    public val onUnauthenticatedRequest: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val sessionCookieName: Output<String>? = null,
    public val sessionTimeout: Output<Int>? = null,
    public val userPoolArn: Output<String>,
    public val userPoolClientId: Output<String>,
    public val userPoolDomain: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.alb.inputs.ListenerDefaultActionAuthenticateCognitoArgs> {
    override fun toJava(): com.pulumi.aws.alb.inputs.ListenerDefaultActionAuthenticateCognitoArgs =
        com.pulumi.aws.alb.inputs.ListenerDefaultActionAuthenticateCognitoArgs.builder()
            .authenticationRequestExtraParams(
                authenticationRequestExtraParams?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
                }),
            )
            .onUnauthenticatedRequest(onUnauthenticatedRequest?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .sessionCookieName(sessionCookieName?.applyValue({ args0 -> args0 }))
            .sessionTimeout(sessionTimeout?.applyValue({ args0 -> args0 }))
            .userPoolArn(userPoolArn.applyValue({ args0 -> args0 }))
            .userPoolClientId(userPoolClientId.applyValue({ args0 -> args0 }))
            .userPoolDomain(userPoolDomain.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerDefaultActionAuthenticateCognitoArgs].
 */
@PulumiTagMarker
public class ListenerDefaultActionAuthenticateCognitoArgsBuilder internal constructor() {
    private var authenticationRequestExtraParams: Output<Map<String, String>>? = null

    private var onUnauthenticatedRequest: Output<String>? = null

    private var scope: Output<String>? = null

    private var sessionCookieName: Output<String>? = null

    private var sessionTimeout: Output<Int>? = null

    private var userPoolArn: Output<String>? = null

    private var userPoolClientId: Output<String>? = null

    private var userPoolDomain: Output<String>? = null

    /**
     * @param value Query parameters to include in the redirect request to the authorization endpoint. Max: 10. Detailed below.
     */
    @JvmName("iayrpsqyihovkdgd")
    public suspend fun authenticationRequestExtraParams(`value`: Output<Map<String, String>>) {
        this.authenticationRequestExtraParams = value
    }

    /**
     * @param value Behavior if the user is not authenticated. Valid values are `deny`, `allow` and `authenticate`.
     */
    @JvmName("vxkajogcowjfvogn")
    public suspend fun onUnauthenticatedRequest(`value`: Output<String>) {
        this.onUnauthenticatedRequest = value
    }

    /**
     * @param value Set of user claims to be requested from the IdP.
     */
    @JvmName("hyullvlngqrwsgdw")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value Name of the cookie used to maintain session information.
     */
    @JvmName("ijrclocfglwsakgj")
    public suspend fun sessionCookieName(`value`: Output<String>) {
        this.sessionCookieName = value
    }

    /**
     * @param value Maximum duration of the authentication session, in seconds.
     */
    @JvmName("ywtosgsenieybaec")
    public suspend fun sessionTimeout(`value`: Output<Int>) {
        this.sessionTimeout = value
    }

    /**
     * @param value ARN of the Cognito user pool.
     */
    @JvmName("lsortnyrbtfhptqw")
    public suspend fun userPoolArn(`value`: Output<String>) {
        this.userPoolArn = value
    }

    /**
     * @param value ID of the Cognito user pool client.
     */
    @JvmName("hexqxguulttngsfb")
    public suspend fun userPoolClientId(`value`: Output<String>) {
        this.userPoolClientId = value
    }

    /**
     * @param value Domain prefix or fully-qualified domain name of the Cognito user pool.
     * The following arguments are optional:
     */
    @JvmName("dkjjjiuyedtevyng")
    public suspend fun userPoolDomain(`value`: Output<String>) {
        this.userPoolDomain = value
    }

    /**
     * @param value Query parameters to include in the redirect request to the authorization endpoint. Max: 10. Detailed below.
     */
    @JvmName("hgfcxlcugomrlwgm")
    public suspend fun authenticationRequestExtraParams(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationRequestExtraParams = mapped
    }

    /**
     * @param values Query parameters to include in the redirect request to the authorization endpoint. Max: 10. Detailed below.
     */
    @JvmName("ngxisbyskhnpljln")
    public fun authenticationRequestExtraParams(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationRequestExtraParams = mapped
    }

    /**
     * @param value Behavior if the user is not authenticated. Valid values are `deny`, `allow` and `authenticate`.
     */
    @JvmName("lfgrheqcvcrcwkfe")
    public suspend fun onUnauthenticatedRequest(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onUnauthenticatedRequest = mapped
    }

    /**
     * @param value Set of user claims to be requested from the IdP.
     */
    @JvmName("treslwraxtdidkgt")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Name of the cookie used to maintain session information.
     */
    @JvmName("lpbjuycenxhmgpkt")
    public suspend fun sessionCookieName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionCookieName = mapped
    }

    /**
     * @param value Maximum duration of the authentication session, in seconds.
     */
    @JvmName("ovwixeluicemnsok")
    public suspend fun sessionTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionTimeout = mapped
    }

    /**
     * @param value ARN of the Cognito user pool.
     */
    @JvmName("isxdobicdjlvnyoo")
    public suspend fun userPoolArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userPoolArn = mapped
    }

    /**
     * @param value ID of the Cognito user pool client.
     */
    @JvmName("mvvahlaqdmlmfjyh")
    public suspend fun userPoolClientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userPoolClientId = mapped
    }

    /**
     * @param value Domain prefix or fully-qualified domain name of the Cognito user pool.
     * The following arguments are optional:
     */
    @JvmName("abmuopobdgotnlue")
    public suspend fun userPoolDomain(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userPoolDomain = mapped
    }

    internal fun build(): ListenerDefaultActionAuthenticateCognitoArgs =
        ListenerDefaultActionAuthenticateCognitoArgs(
            authenticationRequestExtraParams = authenticationRequestExtraParams,
            onUnauthenticatedRequest = onUnauthenticatedRequest,
            scope = scope,
            sessionCookieName = sessionCookieName,
            sessionTimeout = sessionTimeout,
            userPoolArn = userPoolArn ?: throw PulumiNullFieldException("userPoolArn"),
            userPoolClientId = userPoolClientId ?: throw PulumiNullFieldException("userPoolClientId"),
            userPoolDomain = userPoolDomain ?: throw PulumiNullFieldException("userPoolDomain"),
        )
}
