@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.inputs

import com.pulumi.aws.alb.inputs.ListenerDefaultActionFixedResponseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property contentType Content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.
 * The following arguments are optional:
 * @property messageBody Message body.
 * @property statusCode HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
 */
public data class ListenerDefaultActionFixedResponseArgs(
    public val contentType: Output<String>,
    public val messageBody: Output<String>? = null,
    public val statusCode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.alb.inputs.ListenerDefaultActionFixedResponseArgs> {
    override fun toJava(): com.pulumi.aws.alb.inputs.ListenerDefaultActionFixedResponseArgs =
        com.pulumi.aws.alb.inputs.ListenerDefaultActionFixedResponseArgs.builder()
            .contentType(contentType.applyValue({ args0 -> args0 }))
            .messageBody(messageBody?.applyValue({ args0 -> args0 }))
            .statusCode(statusCode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerDefaultActionFixedResponseArgs].
 */
@PulumiTagMarker
public class ListenerDefaultActionFixedResponseArgsBuilder internal constructor() {
    private var contentType: Output<String>? = null

    private var messageBody: Output<String>? = null

    private var statusCode: Output<String>? = null

    /**
     * @param value Content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.
     * The following arguments are optional:
     */
    @JvmName("tqjgnkooxnifnjbd")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value Message body.
     */
    @JvmName("pcpigntdgksmbqqi")
    public suspend fun messageBody(`value`: Output<String>) {
        this.messageBody = value
    }

    /**
     * @param value HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
     */
    @JvmName("cpmsgptuoriqycra")
    public suspend fun statusCode(`value`: Output<String>) {
        this.statusCode = value
    }

    /**
     * @param value Content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.
     * The following arguments are optional:
     */
    @JvmName("svwtrinjvwmtqcls")
    public suspend fun contentType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Message body.
     */
    @JvmName("dfxmwysteurbcnas")
    public suspend fun messageBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageBody = mapped
    }

    /**
     * @param value HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
     */
    @JvmName("eykxpbaiyuaxxpsf")
    public suspend fun statusCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statusCode = mapped
    }

    internal fun build(): ListenerDefaultActionFixedResponseArgs =
        ListenerDefaultActionFixedResponseArgs(
            contentType = contentType ?: throw PulumiNullFieldException("contentType"),
            messageBody = messageBody,
            statusCode = statusCode,
        )
}
