@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.inputs

import com.pulumi.aws.alb.inputs.ListenerRuleActionFixedResponseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property contentType The content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.
 * @property messageBody The message body.
 * @property statusCode The HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
 */
public data class ListenerRuleActionFixedResponseArgs(
    public val contentType: Output<String>,
    public val messageBody: Output<String>? = null,
    public val statusCode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.alb.inputs.ListenerRuleActionFixedResponseArgs> {
    override fun toJava(): com.pulumi.aws.alb.inputs.ListenerRuleActionFixedResponseArgs =
        com.pulumi.aws.alb.inputs.ListenerRuleActionFixedResponseArgs.builder()
            .contentType(contentType.applyValue({ args0 -> args0 }))
            .messageBody(messageBody?.applyValue({ args0 -> args0 }))
            .statusCode(statusCode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerRuleActionFixedResponseArgs].
 */
@PulumiTagMarker
public class ListenerRuleActionFixedResponseArgsBuilder internal constructor() {
    private var contentType: Output<String>? = null

    private var messageBody: Output<String>? = null

    private var statusCode: Output<String>? = null

    /**
     * @param value The content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.
     */
    @JvmName("corouhducdyrkthy")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value The message body.
     */
    @JvmName("qtatqkprkpshbwvk")
    public suspend fun messageBody(`value`: Output<String>) {
        this.messageBody = value
    }

    /**
     * @param value The HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
     */
    @JvmName("pdxeprwrwyvowiaw")
    public suspend fun statusCode(`value`: Output<String>) {
        this.statusCode = value
    }

    /**
     * @param value The content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.
     */
    @JvmName("pedalrvabnpioyqs")
    public suspend fun contentType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value The message body.
     */
    @JvmName("wrpsmceksrxdhdia")
    public suspend fun messageBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageBody = mapped
    }

    /**
     * @param value The HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
     */
    @JvmName("vjvynjbprngjgkty")
    public suspend fun statusCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statusCode = mapped
    }

    internal fun build(): ListenerRuleActionFixedResponseArgs = ListenerRuleActionFixedResponseArgs(
        contentType = contentType ?: throw PulumiNullFieldException("contentType"),
        messageBody = messageBody,
        statusCode = statusCode,
    )
}
