@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.inputs

import com.pulumi.aws.alb.inputs.ListenerRuleActionRedirectArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property host The hostname. This component is not percent-encoded. The hostname can contain `#{host}`. Defaults to `#{host}`.
 * @property path The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}. Defaults to `/#{path}`.
 * @property port The port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
 * @property protocol The protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
 * @property query The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?". Defaults to `#{query}`.
 * @property statusCode The HTTP redirect code. The redirect is either permanent (`HTTP_301`) or temporary (`HTTP_302`).
 */
public data class ListenerRuleActionRedirectArgs(
    public val host: Output<String>? = null,
    public val path: Output<String>? = null,
    public val port: Output<String>? = null,
    public val protocol: Output<String>? = null,
    public val query: Output<String>? = null,
    public val statusCode: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.alb.inputs.ListenerRuleActionRedirectArgs> {
    override fun toJava(): com.pulumi.aws.alb.inputs.ListenerRuleActionRedirectArgs =
        com.pulumi.aws.alb.inputs.ListenerRuleActionRedirectArgs.builder()
            .host(host?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .query(query?.applyValue({ args0 -> args0 }))
            .statusCode(statusCode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerRuleActionRedirectArgs].
 */
@PulumiTagMarker
public class ListenerRuleActionRedirectArgsBuilder internal constructor() {
    private var host: Output<String>? = null

    private var path: Output<String>? = null

    private var port: Output<String>? = null

    private var protocol: Output<String>? = null

    private var query: Output<String>? = null

    private var statusCode: Output<String>? = null

    /**
     * @param value The hostname. This component is not percent-encoded. The hostname can contain `#{host}`. Defaults to `#{host}`.
     */
    @JvmName("kwmihexnnlrdndhc")
    public suspend fun host(`value`: Output<String>) {
        this.host = value
    }

    /**
     * @param value The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}. Defaults to `/#{path}`.
     */
    @JvmName("lcblyckbokqbrrem")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
     */
    @JvmName("njnbcsmktewvmhav")
    public suspend fun port(`value`: Output<String>) {
        this.port = value
    }

    /**
     * @param value The protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
     */
    @JvmName("ndtbjtxvcdjtaqjm")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?". Defaults to `#{query}`.
     */
    @JvmName("tccmvdlgodunyijt")
    public suspend fun query(`value`: Output<String>) {
        this.query = value
    }

    /**
     * @param value The HTTP redirect code. The redirect is either permanent (`HTTP_301`) or temporary (`HTTP_302`).
     */
    @JvmName("soybkvpqvcehhqwv")
    public suspend fun statusCode(`value`: Output<String>) {
        this.statusCode = value
    }

    /**
     * @param value The hostname. This component is not percent-encoded. The hostname can contain `#{host}`. Defaults to `#{host}`.
     */
    @JvmName("kxaqumsqomqrhwra")
    public suspend fun host(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}. Defaults to `/#{path}`.
     */
    @JvmName("oshckfurnnjybpwr")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value The port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
     */
    @JvmName("inrywkuvsxinescd")
    public suspend fun port(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
     */
    @JvmName("cdsfqykcejccosmh")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?". Defaults to `#{query}`.
     */
    @JvmName("oknwhexdliclflot")
    public suspend fun query(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.query = mapped
    }

    /**
     * @param value The HTTP redirect code. The redirect is either permanent (`HTTP_301`) or temporary (`HTTP_302`).
     */
    @JvmName("pmkvvssdqmqxswmy")
    public suspend fun statusCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statusCode = mapped
    }

    internal fun build(): ListenerRuleActionRedirectArgs = ListenerRuleActionRedirectArgs(
        host = host,
        path = path,
        port = port,
        protocol = protocol,
        query = query,
        statusCode = statusCode ?: throw PulumiNullFieldException("statusCode"),
    )
}
